/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne;

import com.opencsv.CSVReader;
import fr.cnav.saturne.CSVDataSource;
import fr.cnav.saturne.CSVExternalDataTable;
import fr.cnav.saturne.DataSource;
import fr.cnav.saturne.DataSourceSet;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.DataTypeSet;
import fr.cnav.saturne.ExternalDataTable;
import fr.cnav.saturne.ExternalDataType;
import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;

public class ModelAccessorWithNomenclaturesHandling
extends ModelAccessor {
    private static final String COLUMN = ":";
    private static final String CSV_DATA_SOURCE_STR = "Csv data Source ";
    private static final int KEY_COL = 0;
    private Map<String, Set<String>> nomenclatureNameMapToReferential;
    private Map<String, Map<String, String>> nomenclatureMapToCodeMapToDescription;
    private boolean shouldInitDescription;

    public ModelAccessorWithNomenclaturesHandling(Standard theStandard, OptionMap options, Logger logger, String dataSourcePackage, Object knowledgeBaseObject, boolean shouldInitDescription) throws IOException {
        this(theStandard, options, logger, dataSourcePackage, knowledgeBaseObject.getClass().getClassLoader(), shouldInitDescription);
    }

    public ModelAccessorWithNomenclaturesHandling(Standard theStandard, OptionMap options, Logger logger, String dataSourcePackage, ClassLoader classLoader, boolean shouldInitDescription) throws IOException {
        super(theStandard, logger);
        this.shouldInitDescription = shouldInitDescription;
        if (shouldInitDescription) {
            this.nomenclatureMapToCodeMapToDescription = new HashMap<String, Map<String, String>>();
        }
        if (dataSourcePackage == null || dataSourcePackage.isEmpty()) {
            throw new IllegalArgumentException("The datasource package cannot be null.");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("The object generated by the class loader of the plugin containing the standard cannot be null.");
        }
        this.nomenclatureNameMapToReferential = new HashMap<String, Set<String>>();
        this.initNomenclatureMap(dataSourcePackage, classLoader, options);
    }

    public ModelAccessorWithNomenclaturesHandling(Standard theStandard, OptionMap options, Logger logger, String dataSourcePackage, Object knowledgeBaseObject) throws IOException {
        this(theStandard, options, logger, dataSourcePackage, knowledgeBaseObject.getClass().getClassLoader());
    }

    public ModelAccessorWithNomenclaturesHandling(Standard theStandard, OptionMap options, Logger logger, String dataSourcePackage, ClassLoader classLoader) throws IOException {
        this(theStandard, options, logger, dataSourcePackage, classLoader, false);
    }

    private void initNomenclatureMap(String dataSourcePackage, ClassLoader classLoader, OptionMap options) throws IOException {
        EList<DataType> datatypes;
        DataTypeSet dataTypesSet;
        EList<DataSource> datasources;
        DataSourceSet dataSourcesSet = this.standard.getDataSources();
        if (dataSourcesSet != null && (datasources = dataSourcesSet.getDatasources()) != null) {
            for (DataSource dataSource : datasources) {
                CSVDataSource csvdataSource = (CSVDataSource)dataSource;
                this.importDataSourceInReferentialMap(csvdataSource.getColumnId(), dataSourcePackage, csvdataSource, classLoader, options);
            }
        }
        if ((dataTypesSet = this.standard.getDataTypes()) != null && (datatypes = dataTypesSet.getDatatypes()) != null) {
            for (DataType dataType : datatypes) {
                if (!(dataType instanceof ExternalDataType)) continue;
                this.initNomenclatureFromExternalReferential(dataSourcePackage, classLoader, (ExternalDataType)dataType, options);
            }
        }
    }

    private void initNomenclatureFromExternalReferential(String dataSourcePackage, ClassLoader classLoader, ExternalDataType externalDatatype, OptionMap options) throws IOException {
        EList<ExternalDataTable> externalDataTables = externalDatatype.getExternalDataTables();
        for (ExternalDataTable externalDataTable : externalDataTables) {
            CSVExternalDataTable csvExternalDataTable;
            DataSource dataSource;
            if (!(externalDataTable instanceof CSVExternalDataTable) || (dataSource = (csvExternalDataTable = (CSVExternalDataTable)externalDataTable).getDataSource()) == null) continue;
            CSVDataSource csvdataSource = (CSVDataSource)dataSource;
            this.importDataSourceInReferentialMap(csvdataSource.getColumnId(), dataSourcePackage, csvdataSource, classLoader, options);
        }
    }

    private void importDataSourceInReferentialMap(String keyColumnId, String dataSourcePackage, CSVDataSource csvdataSource, ClassLoader classLoader, OptionMap options) throws IOException {
        String columnSeparator = csvdataSource.getColumnSeparator();
        String columnDelimiter = csvdataSource.getColumnDelimiter();
        String filename = csvdataSource.getFilename();
        int titleLineNumber = csvdataSource.getTitleLineNumber();
        if (filename == null) {
            throw new IllegalArgumentException(CSV_DATA_SOURCE_STR + csvdataSource.getName() + " find with null file Name.");
        }
        String pathDataSourceCsv = String.valueOf(dataSourcePackage) + "/" + filename;
        URL datasourceUrl = this.getDataSourceUrl(options, pathDataSourceCsv, classLoader);
        if (datasourceUrl == null) {
            throw new IllegalArgumentException("The datasource file " + pathDataSourceCsv + " could not be found from the given object class loader. Make sur The given object has been initialized by the class loader of the used knowledge base");
        }
        InputStream csvStream = datasourceUrl.openStream();
        if (csvStream == null) {
            throw new IllegalArgumentException("The datasource file " + pathDataSourceCsv + " could not be read.");
        }
        HashSet<String> dataSourceTable = new HashSet<String>();
        String externalTypeKey = this.buildKey(csvdataSource);
        if (this.nomenclatureNameMapToReferential.get(externalTypeKey) == null) {
            this.nomenclatureNameMapToReferential.put(externalTypeKey, dataSourceTable);
            BufferedReader breader = null;
            breader = new BufferedReader(new InputStreamReader(csvStream, "UTF8"));
            try {
                CSVReader reader = null;
                reader = columnDelimiter.length() == 0 ? new CSVReader((Reader)breader, columnSeparator.charAt(0), '\u0000') : new CSVReader((Reader)breader, columnSeparator.charAt(0), columnDelimiter.charAt(0), true);
                int columnNumber = this.getColumnNumber(reader, titleLineNumber, keyColumnId);
                if (columnNumber < 0) {
                    throw new IllegalArgumentException("While loading data-source '" + filename + "', the columnId '" + keyColumnId + "' was not found in title line(s).");
                }
                ArrayList<String[]> lines = new ArrayList<String[]>();
                String[] lineRead = reader.readNext();
                while (lineRead != null) {
                    lines.add(lineRead);
                    lineRead = reader.readNext();
                }
                this.extractDataFromCSVLines(lines, csvdataSource, dataSourceTable, columnNumber);
            }
            finally {
                if (breader != null) {
                    breader.close();
                }
            }
        }
    }

    private URL getDataSourceUrl(OptionMap options, String pathDataSourceCsv, ClassLoader classLoader) {
        IFile normFile = (IFile)options.getOption(new Key("fr.cnav.saturne.kbdescriptor.init.workspace.norm.file"));
        if (normFile != null) {
            String slash = "/";
            String projectPath = normFile.getProject().getFullPath().toString();
            String normPath = normFile.getFullPath().toString();
            normPath = normPath.substring(projectPath.length() + 1);
            normPath = normPath.substring(0, normPath.indexOf(slash));
            URI uri = URI.createPlatformResourceURI((String)(String.valueOf(normFile.getProject().getName()) + slash + normPath + slash + pathDataSourceCsv), (boolean)true);
            try {
                return new URL(uri.toString());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return classLoader.getResource(pathDataSourceCsv);
    }

    private void extractDataFromCSVLines(List<String[]> lines, CSVDataSource csvdataSource, Set<String> dataSourceTable, int columnNumber) throws IOException {
        String externalTypeKey = this.buildKey(csvdataSource);
        Map<Object, Object> currentMapCodeToDescription = null;
        if (this.shouldInitDescription) {
            if (!this.nomenclatureMapToCodeMapToDescription.containsKey(externalTypeKey)) {
                currentMapCodeToDescription = new HashMap();
                this.nomenclatureMapToCodeMapToDescription.put(externalTypeKey, currentMapCodeToDescription);
            } else {
                currentMapCodeToDescription = this.nomenclatureMapToCodeMapToDescription.get(externalTypeKey);
            }
        }
        int actualColumnNumber = columnNumber - 1;
        for (String[] line : lines) {
            if (columnNumber > line.length) {
                throw new IllegalArgumentException("While loading data-source '" + csvdataSource.getFilename() + "', the columnId '" + csvdataSource.getColumnId() + "' is greater than the CSV column number.");
            }
            if (line.length == 1) {
                dataSourceTable.add(line[0]);
                if (!this.shouldInitDescription) continue;
                currentMapCodeToDescription.put(line[actualColumnNumber], "");
                continue;
            }
            dataSourceTable.add(line[actualColumnNumber]);
            if (!this.shouldInitDescription) continue;
            if (line.length > actualColumnNumber + 1) {
                String description = line[actualColumnNumber + 1];
                currentMapCodeToDescription.put(line[actualColumnNumber], description);
                continue;
            }
            currentMapCodeToDescription.put(line[actualColumnNumber], "");
        }
    }

    /*
     * Unable to fully structure code
     */
    private int getColumnNumber(CSVReader csvReader, int titleLineNumber, String columnId) throws IOException {
        block6: {
            columnNumber = -1;
            readTitleLineNumber = 0;
            try {
                columnNumber = Integer.parseInt(columnId);
                break block6;
            }
            catch (NumberFormatException v0) {
                i = 0;
                ** while (i < titleLineNumber)
            }
lbl-1000:
            // 1 sources

            {
                titleLine = csvReader.readNext();
                ++readTitleLineNumber;
                j = 0;
                while (j < titleLine.length) {
                    if (titleLine[j].equalsIgnoreCase(columnId)) {
                        columnNumber = j;
                        break block2;
                    }
                    ++j;
                }
                ++i;
                continue;
            }
        }
        i = 0;
        while (i < titleLineNumber - readTitleLineNumber) {
            csvReader.readNext();
            ++i;
        }
        return columnNumber;
    }

    public Set<String> getReferential(String referentialName, String columnId) {
        return this.nomenclatureNameMapToReferential.get(this.buildKey(referentialName, columnId));
    }

    public String buildKey(String datasourceName, String columnId) {
        return String.valueOf(datasourceName) + COLUMN + columnId;
    }

    public String buildKey(CSVDataSource csvdataSource) {
        String filename = csvdataSource.getFilename();
        if (filename == null) {
            throw new IllegalArgumentException(CSV_DATA_SOURCE_STR + csvdataSource.getName() + " find with null file Name.");
        }
        String columnId = csvdataSource.getColumnId();
        if (columnId == null) {
            throw new IllegalArgumentException(CSV_DATA_SOURCE_STR + csvdataSource.getName() + " find with null column Id.");
        }
        return String.valueOf(filename) + COLUMN + columnId;
    }

    public Map<String, Map<String, String>> getNomenclatureMapToCodeMapToDescription() {
        return this.nomenclatureMapToCodeMapToDescription;
    }
}

