/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.proxy;

import fr.cnav.autocontrole.ui.AutocontrolUiPlugin;
import fr.cnav.autocontrole.ui.proxy.ReflectUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class AbstractDialog
extends TitleAreaDialog {
    private String title;
    private int width;
    private int height;
    private AutocontrolUiPlugin plugin;
    private String help;

    protected AbstractDialog(Shell parentShell, String title, int width, int height, AutocontrolUiPlugin plugin, String help) {
        super(parentShell);
        this.title = title;
        this.width = width;
        this.height = height;
        this.plugin = plugin;
        this.help = help;
        this.setHelpAvailable(help != null);
        this.setShellStyle(68848);
    }

    public String getTitle() {
        return this.title;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getHelp() {
        return this.help;
    }

    public void openTray(DialogTray tray) throws IllegalStateException, UnsupportedOperationException {
        super.openTray(tray);
        Control trayControl = (Control)this.getFieldValue("trayControl");
        final Label rightSeparator = (Label)this.getFieldValue("rightSeparator");
        final Sash sash = (Sash)this.getFieldValue("sash");
        if (trayControl == null || rightSeparator == null || sash == null) {
            return;
        }
        final GridData data = (GridData)trayControl.getLayoutData();
        sash.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 1) {
                    Shell shell = AbstractDialog.this.getShell();
                    Rectangle clientArea = shell.getClientArea();
                    int newWidth = clientArea.width - event.x - (sash.getSize().x + rightSeparator.getSize().x);
                    if (newWidth != data.widthHint) {
                        data.widthHint = newWidth;
                        shell.layout();
                    }
                }
            }
        });
    }

    private <T> T getFieldValue(String name) {
        try {
            Field field = ReflectUtil.getField(TrayDialog.class, name);
            if (field != null) {
                Object value = ReflectUtil.getValue(field, (Object)this);
                return (T)value;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(this.getShellText());
        this.setTitle(this.title);
        this.setTitleImage(this.getDefaultImage(this.getImagePath()));
        this.setMessage(this.getDefaultMessage());
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = this.getContainerMargin();
        layout.marginHeight = this.getContainerMargin();
        layout.verticalSpacing = 0;
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createUI(container);
        if (this.getContainerMargin() == 0) {
            this.createSeparator(container);
        }
        shell.addHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent e) {
                if (AbstractDialog.this.getTray() != null) {
                    AbstractDialog.this.closeTray();
                    this.updatedHelpButton(false);
                    return;
                }
                DialogTray tray = new DialogTray(){

                    protected Control createContents(Composite parent) {
                        URL resource = AbstractDialog.this.plugin.getBundle().getResource(AbstractDialog.this.help);
                        try {
                            resource = FileLocator.resolve((URL)resource);
                        }
                        catch (IOException ex) {
                            AutocontrolUiPlugin.log((IStatus)new Status(4, AbstractDialog.class.getCanonicalName(), "File Locator resolve error", (Throwable)ex));
                        }
                        Browser browser = new Browser(parent, 0);
                        browser.setSize(500, 800);
                        if (resource != null) {
                            browser.setUrl(resource.toString());
                        }
                        return browser;
                    }
                };
                AbstractDialog.this.openTray(tray);
                this.updatedHelpButton(true);
            }

            private void updatedHelpButton(boolean pushed) {
                try {
                    Field field = ReflectUtil.getField(TrayDialog.class, "fHelpButton");
                    ToolItem fHelpButton = (ToolItem)ReflectUtil.getValue(field, (Object)AbstractDialog.this);
                    fHelpButton.setSelection(pushed);
                }
                catch (Exception ex) {
                    AutocontrolUiPlugin.log((IStatus)new Status(4, AbstractDialog.class.getCanonicalName(), "Help Access error", (Throwable)ex));
                }
            }
        });
        shell.setActive();
        return area;
    }

    protected Button createCheckbox(Composite parent, String label) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        this.setButtonLayoutData(button);
        return button;
    }

    protected Control createHelpControl(Composite parent) {
        ToolBar toolBar = (ToolBar)super.createHelpControl(parent);
        this.createToolItemsForToolBar(toolBar);
        return toolBar;
    }

    protected void createToolItemsForToolBar(ToolBar toolBar) {
    }

    protected final ToolItem createToolItem(ToolBar toolBar, String label) {
        return this.createToolItem(toolBar, null, label);
    }

    protected final ToolItem createToolItem(ToolBar toolBar, String iconPath, String toolTip) {
        ToolItem toolItem = new ToolItem(toolBar, 8);
        if (iconPath == null) {
            toolItem.setText(toolTip);
        } else {
            Image image = this.getDefaultImage(iconPath);
            toolItem.setImage(image);
            toolItem.setToolTipText(toolTip);
        }
        return toolItem;
    }

    protected Label createSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(768));
        return separator;
    }

    protected int getContainerMargin() {
        return 0;
    }

    protected abstract String getImagePath();

    protected final Point getInitialSize() {
        return new Point(this.width, this.height);
    }

    protected final Image getDefaultImage(String path) {
        return null;
    }

    protected abstract String getDefaultMessage();

    protected abstract String getShellText();

    protected abstract void createUI(Composite var1);
}

