/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.handlers;

import fr.cnav.autocontrole.AutoCtrlValidator;
import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.exception.ExceptionKind;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.autocontrole.ui.AutocontrolUiPlugin;
import fr.cnav.autocontrole.ui.Messages;
import fr.cnav.autocontrole.ui.views.IndividualView;
import fr.cnav.autocontrole.ui.views.NormeView;
import fr.cnav.autocontrole.ui.views.PrincipaleView;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractValidateHandler
extends AbstractHandler {
    protected void executeControle(Shell shell, File file) {
        try {
            String maxAnomalie = AutocontrolUiPlugin.getDefault().getPreferenceStore().getString("PREF_MAX_ANOMALIE");
            Integer factorizationThreshold = AutocontrolUiPlugin.getDefault().getPreferenceStore().getInt("ANOMALIE_GROUPING_IS_ACTIVATED");
            try {
                new MessageFile(file);
                AutocontrolUiPlugin.getDefault().getPreferenceStore().putValue("VALIDATION_FOLDER", file.getParent());
            }
            catch (IOException iOException) {
                MessageDialog.openError((Shell)shell, (String)Messages.OpenHandler_4, (String)(String.valueOf(Messages.OpenHandler_5) + file.getAbsolutePath() + Messages.OpenHandler_6));
                this.resetView(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage());
                MessageFile.razInstance();
                return;
            }
            final AutoCtrlValidator autoCtrlValidator = new AutoCtrlValidator(maxAnomalie, factorizationThreshold);
            final IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            autoCtrlValidator.pepareValidationEnvironment((IProgressMonitor)nullProgressMonitor);
            boolean isIntegrityConfirmed = autoCtrlValidator.validateIntegrity((IProgressMonitor)nullProgressMonitor, StandardHelper.getInstance().getNormDescriptor());
            if (isIntegrityConfirmed || !isIntegrityConfirmed && MessageDialog.openConfirm((Shell)shell, (String)Messages.ConfirmInvalidEntryFileHeader, (String)Messages.ConfirmInvalidEntryFileBody)) {
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(Messages.OpenHandler_7, 120);
                            AbstractValidateHandler.this.resetView(page);
                            autoCtrlValidator.validate(monitor);
                            monitor.subTask(Messages.AbstractValidateHandler_0);
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractValidateHandler.this.initViews(page);
                                }
                            });
                            monitor.done();
                            if (monitor.isCanceled()) {
                                throw new InterruptedException(Messages.AbstractValidateHandler_1);
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    AutocontrolUiPlugin.log((IStatus)new Status(4, "fr.cnav.autocontrole.ui", ExceptionKind.ERROR_TECHNIC_VALIDATION.getMessage(), (Throwable)e));
                    this.resetView(page);
                    MessageDialog.openError((Shell)shell, (String)Messages.OpenHandler_8, (String)String.format(Messages.AbstractValidateHandler_2, ExceptionKind.ERROR_TECHNIC_VALIDATION.getMessage()));
                    MessageFile.razInstance();
                }
                catch (InvocationTargetException e) {
                    this.resetView(page);
                    if (e.getTargetException() instanceof AutoCtrlException) {
                        AutocontrolUiPlugin.log((IStatus)new Status(4, "fr.cnav.autocontrole.ui", e.getCause().getMessage(), (Throwable)e));
                        e.getTargetException().printStackTrace();
                        MessageDialog.openError((Shell)shell, (String)Messages.OpenHandler_8, (String)e.getCause().getMessage());
                    } else {
                        e.printStackTrace();
                        AutocontrolUiPlugin.log((IStatus)new Status(4, "fr.cnav.autocontrole.ui", ExceptionKind.ERROR_TECHNIC_VALIDATION.getMessage(), (Throwable)e));
                        MessageDialog.openError((Shell)shell, (String)Messages.OpenHandler_8, (String)String.format(Messages.AbstractValidateHandler_2, ExceptionKind.ERROR_TECHNIC_VALIDATION.getMessage()));
                        this.showErrorLog();
                    }
                    MessageFile.razInstance();
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            AutocontrolUiPlugin.log((IStatus)new Status(4, "fr.cnav.autocontrole.ui", ExceptionKind.ERROR_TECHNIC_VALIDATION.getMessage(), t));
            MessageDialog.openError((Shell)shell, (String)Messages.OpenHandler_8, (String)String.format(Messages.AbstractValidateHandler_2, ExceptionKind.ERROR_TECHNIC_VALIDATION.getMessage()));
            this.showErrorLog();
        }
    }

    private void showErrorLog() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
        }
        catch (PartInitException e) {
            e.printStackTrace();
            AutocontrolUiPlugin.log((IStatus)new Status(4, "fr.cnav.autocontrole.ui", ExceptionKind.ERROR_OPENING_ERROR_LOG.getMessage(), (Throwable)e));
        }
    }

    private void initViews(IWorkbenchPage page) {
        IViewPart viewSalarie;
        IViewPart viewNorme;
        IViewPart viewPPl = page.findView("fr.cnav.autocontrole.ui.views.PrincipaleView");
        if (viewPPl instanceof PrincipaleView) {
            ((PrincipaleView)viewPPl).initializeData();
        }
        if ((viewNorme = page.findView("fr.cnav.autocontrole.ui.views.NormeView")) instanceof NormeView) {
            ((NormeView)viewNorme).initializeData();
        }
        if ((viewSalarie = page.findView("fr.cnav.autocontrole.ui.views.IndividualView")) instanceof IndividualView) {
            ((IndividualView)viewSalarie).initializeData(null);
        }
        if (viewPPl instanceof PrincipaleView) {
            ((PrincipaleView)viewPPl).selectFistAnomalie();
        }
    }

    private void resetViews(IWorkbenchPage page) {
        IViewPart viewSalarie;
        IViewPart viewPPl = page.findView("fr.cnav.autocontrole.ui.views.PrincipaleView");
        if (viewPPl instanceof PrincipaleView) {
            ((PrincipaleView)viewPPl).resetData();
        }
        if ((viewSalarie = page.findView("fr.cnav.autocontrole.ui.views.IndividualView")) instanceof IndividualView) {
            ((IndividualView)viewSalarie).resetData();
        }
    }

    private void resetView(final IWorkbenchPage page) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractValidateHandler.this.resetViews(page);
            }
        });
    }
}

