/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.common.fileselector.withsrctag;

import fr.cnav.saturne.common.fileselector.ResourceFileSelectTreeContentProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceFileSelectionWithSrcTagFilterDialog
extends ElementTreeSelectionDialog {
    protected static final IStatus OK = new Status(0, "PluginId", 0, "", null);
    protected static final IStatus ERROR = new Status(4, "PluginId", 0, "", null);
    private static ITreeContentProvider contentProvider = new ResourceFileSelectTreeContentProvider();
    private String[] extensions;
    private List<String> srcFolderList;

    public ResourceFileSelectionWithSrcTagFilterDialog(String projetName, String title, String message, String[] type) {
        this(Display.getDefault().getActiveShell(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider(), contentProvider);
        this.extensions = type;
        this.setTitle(title);
        this.setMessage(message);
        if (projetName == null) {
            this.setInput(this.computeInput());
        } else {
            this.setInput(this.computeInput(projetName));
        }
        this.setValidator(this.getValidator());
    }

    public ResourceFileSelectionWithSrcTagFilterDialog(String title, String message, String[] type) {
        this(null, title, message, type);
    }

    public ResourceFileSelectionWithSrcTagFilterDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
    }

    protected ISelectionStatusValidator getValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                return selection.length == 1 && selection[0] instanceof IFile && ResourceFileSelectionWithSrcTagFilterDialog.this.checkFileIsInASrcFolder((IFile)selection[0]) && ResourceFileSelectionWithSrcTagFilterDialog.this.checkExtension(((IFile)selection[0]).getFileExtension()) ? OK : ERROR;
            }
        };
    }

    private boolean checkFileIsInASrcFolder(IFile iFile) {
        String fullPath = iFile.getFullPath().toString();
        for (String scrFolder : this.srcFolderList) {
            if (!fullPath.startsWith(scrFolder)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkExtension(String name) {
        boolean result = false;
        if ("*".equals(name)) {
            result = true;
        } else {
            int i = 0;
            while (i < this.extensions.length) {
                if (this.extensions[i].equals(name)) {
                    result = true;
                    break;
                }
                if ("*".equals(this.extensions[i])) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    protected void completActionOnProject(IProject iProject) {
        this.extractSrcFolderList(iProject);
    }

    private void extractSrcFolderList(IProject iProject) {
        this.srcFolderList = new ArrayList<String>();
        try {
            if (iProject.isOpen() && this.isJavaPrjNature(iProject)) {
                IJavaProject javaProject = JavaCore.create((IProject)iProject);
                IClasspathEntry[] classpathEntries = null;
                classpathEntries = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < classpathEntries.length) {
                    IPath path;
                    String srcPath;
                    IClasspathEntry entry = classpathEntries[i];
                    if (entry.getContentKind() == 1 && (srcPath = (path = entry.getPath()).toString()).startsWith("/" + iProject.getName() + "/")) {
                        this.srcFolderList.add(srcPath);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private boolean isJavaPrjNature(IProject project) throws CoreException {
        String[] stringArray = project.getDescription().getNatureIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if ("org.eclipse.jdt.core.javanature".equals(nature)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getFileNameWithSrcFolderTag() {
        String methodResult = "";
        Object[] restults = this.getResult();
        if (restults != null && restults.length > 0) {
            IFile f = (IFile)this.getResult()[0];
            methodResult = f.toString().replaceFirst("^L", "");
            for (String folderPath : this.srcFolderList) {
                if (!methodResult.startsWith(folderPath)) continue;
                methodResult = methodResult.replaceFirst(String.valueOf(folderPath) + "/", String.valueOf(folderPath) + "/" + "%srcTag%");
                break;
            }
        }
        return methodResult;
    }

    private Object[] computeInput() {
        return this.computeInput(ResourcesPlugin.getWorkspace().getRoot().getProjects());
    }

    private Object[] computeInput(String prjName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(prjName);
        IProject[] projects = new IProject[]{project};
        return this.computeInput(projects);
    }

    private Object[] computeInput(IProject[] projects) {
        int i = 0;
        while (i < projects.length) {
            try {
                projects[i].refreshLocal(2, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ArrayList<IProject> openProjects = new ArrayList<IProject>(projects.length);
        int i2 = 0;
        while (i2 < projects.length) {
            if (projects[i2].isOpen()) {
                openProjects.add(projects[i2]);
                this.completActionOnProject(projects[i2]);
            }
            ++i2;
        }
        return openProjects.toArray();
    }
}

