/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.ForeignKeyBindingDescription;
import fr.cnav.saturne.api.model.access.MessageDescription;
import fr.cnav.saturne.api.model.access.MessageElementDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleRegistry;
import fr.cnav.saturne.validator.message.MessageElementFactory;
import fr.cnav.saturne.validator.syntax.Cce01SyntaxControl;
import fr.cnav.saturne.validator.syntax.SyntacticControlCode;
import fr.cnav.saturne.validator.syntax.SyntaxCtrlBlockFactory;
import fr.cnav.saturne.validator.syntax.SyntaxCtrlFieldFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SyntacticRuleRegistry
implements IRuleRegistry {
    private StandardAccessor modelAccessor;
    private Map<Optional<DeclarationDescription>, Map<MessageElementDescription, Set<IRule>>> ruleSetMapByContextByDeclaration;
    private Set<IRule> allRules;
    private Set<MessageElementDescription> allMessageElementUsed;
    private int currentRuleId;
    private SyntaxCtrlFieldFactory syntaxCtrlRubFactory;
    private SyntaxCtrlBlockFactory syntaxCtrlSubGroupFactory;
    private MessageElementFactory messageElementFactory;
    private ControlMessages controlMessages;

    public SyntacticRuleRegistry(StandardAccessor modelAccessor, ControlMessages controlMessages) {
        this.modelAccessor = modelAccessor;
        this.messageElementFactory = new MessageElementFactory(modelAccessor);
        this.syntaxCtrlRubFactory = new SyntaxCtrlFieldFactory(modelAccessor, controlMessages);
        this.syntaxCtrlSubGroupFactory = new SyntaxCtrlBlockFactory(modelAccessor.getStandardDescription(), controlMessages, this.messageElementFactory);
        this.controlMessages = controlMessages;
        this.initRuleRegistry();
    }

    SyntacticRuleRegistry() {
    }

    private void initRuleRegistry() {
        this.ruleSetMapByContextByDeclaration = new HashMap<Optional<DeclarationDescription>, Map<MessageElementDescription, Set<IRule>>>();
        this.allRules = new HashSet<IRule>();
        this.allMessageElementUsed = new HashSet<MessageElementDescription>();
        StandardDescription standard = this.modelAccessor.getStandardDescription();
        LinkedHashMap emptySetMultiMap = new LinkedHashMap();
        this.ruleSetMapByContextByDeclaration.put(Optional.empty(), emptySetMultiMap);
        for (DeclarationDescription declaration : standard.getDeclarations()) {
            LinkedHashMap emptySetMap = new LinkedHashMap();
            this.ruleSetMapByContextByDeclaration.put(Optional.of(declaration), emptySetMap);
        }
        MessageDescription message = standard.getMessage();
        if (message == null) {
            return;
        }
        for (DeclarationDescription declaration : standard.getDeclarations()) {
            this.initRuleRegistry(message, declaration);
        }
        this.initRuleRegistry(message, null);
    }

    private void initRuleRegistry(MessageDescription aMessage, DeclarationDescription aDeclaration) {
        if (aMessage.getHeaderBlock() != null) {
            this.initRuleRegistry((BlockDescription)aMessage.getHeaderBlock(), aDeclaration);
            this.initRuleRegistry((BlockDescription)aMessage.getHeaderBlock().getDeclarationBlock(), aDeclaration);
        }
        if (aMessage.getFooterBlock() != null) {
            this.initRuleRegistry(aMessage.getFooterBlock(), aDeclaration);
        }
    }

    private void initRuleRegistry(BlockDescription aBlock, DeclarationDescription declaration) {
        this.processInitRuleForBlock(aBlock, declaration);
        for (FieldDescription currentField : aBlock.getFields()) {
            this.processInitRuleForField(currentField, declaration);
        }
        for (BlockDescription currentBlock : aBlock.getChildren()) {
            this.initRuleRegistry(currentBlock, declaration);
        }
    }

    private void processInitRuleForField(FieldDescription field, DeclarationDescription declaration) {
        BlockDescription curContext = (BlockDescription)field.getParent();
        Set<IRule> curRuleSet = this.getRulesForContext(curContext, declaration);
        this.initRuleForElement(field, curRuleSet, declaration);
    }

    private void processInitRuleForBlock(BlockDescription block, DeclarationDescription declaration) {
        Set<IRule> curRuleSet = this.getRulesForContext(block, declaration);
        this.initRuleForBlock(block, curRuleSet, declaration);
    }

    private boolean isForbiden(BlockDescription block, DeclarationDescription declaration) {
        return declaration.getBlockUpperBound(block) == 0 || declaration.getUsage((MessageElementDescription)block) == UsageType.FORBIDDEN;
    }

    private void initRuleForBlock(BlockDescription block, Set<IRule> curRuleSet, DeclarationDescription declaration) {
        if (declaration == null || !this.isForbiden(block, declaration)) {
            this.allMessageElementUsed.add((MessageElementDescription)block);
            curRuleSet.add(this.syntaxCtrlSubGroupFactory.getCST01Rule(this.getAndIncrCurrentRuleId(), block, declaration));
            curRuleSet.add(this.syntaxCtrlSubGroupFactory.getCST05Rule(this.getAndIncrCurrentRuleId(), block, declaration));
            HashSet<BlockDescription> rulesByEClass = new HashSet<BlockDescription>();
            for (BlockDescription children : block.getChildrenBlocks()) {
                if (rulesByEClass.contains(children)) continue;
                curRuleSet.add(this.syntaxCtrlSubGroupFactory.getCST02Rule(this.getAndIncrCurrentRuleId(), children, declaration));
                rulesByEClass.add(children);
                this.allMessageElementUsed.add((MessageElementDescription)children);
            }
            for (FieldDescription currentField : block.getFields()) {
                curRuleSet.add(this.syntaxCtrlSubGroupFactory.getCST03Rule(this.getAndIncrCurrentRuleId(), block, currentField, declaration));
                this.allMessageElementUsed.add((MessageElementDescription)currentField);
            }
            for (ForeignKeyBindingDescription binding : block.getForeignKeyBindings()) {
                FieldDescription localField = null;
                for (FieldDescription field : block.getFields()) {
                    if (!field.getFullQualifiedId().equals(binding.getLocalFieldId())) continue;
                    localField = field;
                }
                if (localField == null) continue;
                Cce01SyntaxControl ruleCCE = new Cce01SyntaxControl(this.getAndIncrCurrentRuleId(), SyntacticControlCode.CCE_01.getCode(), localField, this.controlMessages, declaration, this.modelAccessor, binding);
                curRuleSet.add(ruleCCE);
            }
            this.allRules.addAll(curRuleSet);
        }
    }

    private boolean ruleNeeded(FieldDescription field, SyntacticControlCode code, DeclarationDescription declaration) {
        boolean result = false;
        NatureType nature = field.getDataType().getNature();
        switch (code) {
            case CSL_00: {
                String regexp = field.getDataType().getRegexp();
                result = nature != NatureType.DATE && regexp != null && !"".equals(regexp);
                break;
            }
            case CSL_01: {
                result = nature != NatureType.DATE && nature != NatureType.ENUMERATION;
                break;
            }
            case CSL_03: {
                result = nature == NatureType.DATE;
                break;
            }
            case CSL_02: {
                result = nature == NatureType.NUMERIC;
                break;
            }
            case CSL_11: {
                result = nature == NatureType.ENUMERATION;
                break;
            }
            case CST_04: {
                if (declaration == null) {
                    result = field.getUsage() == UsageType.FORBIDDEN;
                    break;
                }
                result = declaration.getUsage((MessageElementDescription)field) == UsageType.FORBIDDEN;
                break;
            }
            case CSL_04: {
                result = nature == NatureType.DATE;
                break;
            }
            case CST_07: {
                result = false;
                break;
            }
            case CRE: {
                result = false;
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    private void initRuleForElement(FieldDescription aField, Set<IRule> curRuleSet, DeclarationDescription declaration) {
        SyntacticControlCode[] syntacticControlCodeArray = SyntacticControlCode.values();
        int n = syntacticControlCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IRule curRule;
            SyntacticControlCode kind = syntacticControlCodeArray[n2];
            if (this.ruleNeeded(aField, kind, declaration) && !kind.isBlockRule() && (curRule = this.syntaxCtrlRubFactory.getRule(this.getAndIncrCurrentRuleId(), aField, kind, declaration)) != null) {
                curRuleSet.add(curRule);
                this.allRules.add(curRule);
                this.allMessageElementUsed.add((MessageElementDescription)aField);
            }
            ++n2;
        }
    }

    public Set<IRule> getRulesForContext(BlockDescription context, DeclarationDescription declaration) {
        Set<IRule> result = new LinkedHashSet<IRule>();
        Optional<DeclarationDescription> optDecl = Optional.ofNullable(declaration);
        if (this.ruleSetMapByContextByDeclaration.get(optDecl) != null && this.ruleSetMapByContextByDeclaration.get(optDecl).get(context) == null) {
            this.ruleSetMapByContextByDeclaration.get(optDecl).put((MessageElementDescription)context, result);
        } else if (this.ruleSetMapByContextByDeclaration.get(optDecl) != null && this.ruleSetMapByContextByDeclaration.get(optDecl).get(context) != null) {
            result = this.ruleSetMapByContextByDeclaration.get(optDecl).get(context);
        }
        return result;
    }

    @Override
    public Set<? extends IRule> getAllRules() {
        return this.allRules;
    }

    @Override
    public boolean uses(FieldDescription aField) {
        return this.allMessageElementUsed.contains(aField);
    }

    public int getAndIncrCurrentRuleId() {
        return this.currentRuleId++;
    }

    public ControlMessages getControlMessages() {
        return this.controlMessages;
    }
}

