/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report;

import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.report.model.ContextField;
import fr.cnav.saturne.report.model.Report;
import fr.cnav.saturne.validator.ITreeConsumer;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import fr.cnav.saturne.validator.report.impl.ReportContextDescriptor;
import java.util.HashMap;
import java.util.Map;

public class ReportContextHandler
implements ITreeConsumer {
    private Context currentContext;
    private final ReportContextDescriptor reportContextDescriptor;
    private final Map<Integer, Context> lineNumberToContextMap;
    private IMessageBlock blockContext;
    private Integer blockFirstLineNumber;

    public ReportContextHandler(ReportContextDescriptor theReportContextDescriptor, Report theReport) {
        this.reportContextDescriptor = theReportContextDescriptor;
        this.lineNumberToContextMap = new HashMap<Integer, Context>();
        Context rootContext = theReport.getRootContext();
        this.lineNumberToContextMap.put(1, rootContext);
        this.extractContext(rootContext);
        this.currentContext = null;
        this.blockFirstLineNumber = null;
    }

    @Override
    public void startTree() throws TreeProcessingException {
    }

    @Override
    public void endTree() throws TreeProcessingException {
    }

    @Override
    public void enterBlock(IMessageBlock block) throws TreeProcessingException {
        if (this.reportContextDescriptor.isABlockContext(block)) {
            this.blockContext = block;
            this.blockFirstLineNumber = this.reportContextDescriptor.isABlockRootContext(block) ? Integer.valueOf(1) : null;
        }
    }

    @Override
    public void exitBlock(IMessageBlock block) throws TreeProcessingException {
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
        this.computeContextField(field);
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
        this.computeContextField(field);
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
        this.computeContextField(field);
    }

    private void extractContext(Context context) {
        for (Context childContext : context.getContextChildren()) {
            this.lineNumberToContextMap.put(childContext.getStartLine(), childContext);
            this.extractContext(childContext);
        }
    }

    private Context getContext(int subgroupFirstLineNumber) {
        Context context = this.lineNumberToContextMap.get(subgroupFirstLineNumber);
        return context;
    }

    private void computeContextField(IMessageField<?> field) {
        if (this.blockFirstLineNumber == null) {
            this.blockFirstLineNumber = field.getFieldLocalizer().getLineNumber();
        }
        if (this.blockContext != null) {
            this.currentContext = this.getContext(this.blockFirstLineNumber);
            String fieldId = field.getStandardFieldDescription().getFullQualifiedId();
            if (this.reportContextDescriptor.isFieldInContext(fieldId) && this.currentContext != null) {
                String value = field.getOriginalValueAsString();
                ContextField contextField = new ContextField(this.reportContextDescriptor.getSerializationName(fieldId), value);
                this.currentContext.addContextField(contextField);
            }
        }
    }
}

