/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.csv.importer;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.validator.positional.csv.CsvInfo;
import fr.cnav.saturne.validator.positional.csv.CsvProblemSeverity;
import fr.cnav.saturne.validator.positional.csv.IValidationRule;
import fr.cnav.saturne.validator.positional.csv.importer.PositionalFixModelCSVMapping;

public class BlockPositionalMappingRule
implements IValidationRule {
    private static final String MESSAGE_NO_CORRESPONDING_BLOCK_IN_NORM = "The block with the given id does not exist in the norm. Please fix it to be able to continue import.";
    private int blockIdColumnRank;
    private ModelAccessor modelAccessor;

    public BlockPositionalMappingRule(int blockIdColumnRank, Standard theStandard) {
        if (theStandard == null) {
            throw new IllegalArgumentException("the Standard cannot be null.");
        }
        this.blockIdColumnRank = blockIdColumnRank;
        this.modelAccessor = new ModelAccessor(theStandard);
    }

    @Override
    public CsvInfo validate(String[] line) {
        Block block;
        String blockId = null;
        if (line != null && this.blockIdColumnRank < line.length) {
            blockId = line[this.blockIdColumnRank];
        }
        if (blockId != null && !blockId.isEmpty() && (block = this.modelAccessor.getBlock(blockId)) == null) {
            return new CsvInfo(CsvProblemSeverity.FATAL, PositionalFixModelCSVMapping.TITLES.get(this.blockIdColumnRank), String.format(MESSAGE_NO_CORRESPONDING_BLOCK_IN_NORM + blockId, new Object[0]));
        }
        return null;
    }
}

