/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.xml;

import fr.cnav.saturne.api.model.access.DeclarationBlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.validator.ITreeAndDeclarationConsumer;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.conversion.OriginalValueOptionValue;
import fr.cnav.saturne.validator.conversion.xml.BlockDeclarationAnnotation;
import fr.cnav.saturne.validator.conversion.xml.XMLSerializer;
import fr.cnav.saturne.validator.message.MessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.io.OutputStream;
import java.util.List;
import java.util.Stack;

public class XMLBufferingSerializer
implements ITreeAndDeclarationConsumer {
    IMessageBlock declRoot;
    final Stack<IMessageBlock> stack = new Stack();
    XMLSerializer serializer;
    private boolean serializing = true;

    public XMLBufferingSerializer(StandardDescription standard, OutputStream outputStream, String encoding, OriginalValueOptionValue emitOriginalValue, boolean emitOriginalLineNumber) throws ConversionSerializationException {
        this.serializer = new XMLSerializer(standard, outputStream, encoding, emitOriginalValue, emitOriginalLineNumber);
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) {
    }

    @Override
    public void signalDateField(IMessageFieldDate field) {
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) {
    }

    @Override
    public void signalDeclaration(IMessageBlock block, DeclarationDescription declaration) throws TreeProcessingException {
        if (this.declRoot != null) {
            if (declaration == null) {
                this.clearChildren(this.declRoot);
            }
            ((MessageBlock)this.declRoot).getAnnotations().add(new BlockDeclarationAnnotation(declaration));
            this.flushBlocks(this.declRoot);
            this.serializing = true;
            this.clearChildren(this.declRoot);
            this.declRoot = null;
        }
    }

    private void clearChildren(IMessageBlock block) {
        for (List<IMessageBlock> child : block.getChildren()) {
            child.clear();
        }
    }

    private void flushBlocks(IMessageBlock block) throws TreeProcessingException {
        this.serializer.enterBlock(block);
        for (List<IMessageBlock> listchild : block.getChildren()) {
            for (IMessageBlock child : listchild) {
                this.flushBlocks(child);
            }
        }
        if (!this.stack.contains(block)) {
            this.serializer.exitBlock(block);
        }
    }

    @Override
    public void startTree() throws TreeProcessingException {
        this.serializer.startTree();
    }

    @Override
    public void endTree() throws TreeProcessingException {
        this.serializer.endTree();
    }

    @Override
    public void enterBlock(IMessageBlock bloc) throws TreeProcessingException {
        if (bloc.getStandardBlockDescription() instanceof DeclarationBlockDescription) {
            this.stack.add(bloc);
            this.serializing = false;
            if (this.declRoot != null) {
                this.serializer.enterBlock(this.declRoot);
                this.serializer.exitBlock(this.declRoot);
            }
            this.declRoot = bloc;
        } else if (this.serializing) {
            this.serializer.enterBlock(bloc);
        } else if (!this.serializing) {
            this.stack.add(bloc);
        }
    }

    @Override
    public void exitBlock(IMessageBlock block) throws TreeProcessingException {
        if (!this.stack.isEmpty() && this.stack.peek().getStandardBlockDescription() instanceof DeclarationBlockDescription) {
            if (this.declRoot != null) {
                this.serializer.enterBlock(this.declRoot);
                this.clearChildren(this.declRoot);
            }
            this.declRoot = null;
            this.stack.clear();
            this.serializing = true;
        }
        if (this.stack.size() >= 1) {
            this.stack.pop();
        } else if (this.serializing) {
            this.serializer.exitBlock(this.declRoot);
        }
    }
}

