/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.runtime;

import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.MessageElementDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.dsl.runtime.Description;
import fr.cnav.saturne.utils.DataTypeUtil;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class BuiltinFunctions {
    private static final DateTimeFormatter DATE_FORMATER = DateTimeFormatter.ofPattern("ddMMuuuu").withResolverStyle(ResolverStyle.STRICT);
    private static ZoneId defaultZoneId = ZoneId.systemDefault();
    private static final int DATE_LENGTH = 8;

    private BuiltinFunctions() {
    }

    private static Date delayedDate(Date ref, int increment, DateModification mode) {
        if (ref != null && increment != 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(ref);
            Date result = null;
            switch (mode) {
                case DAY: {
                    calendar.add(5, increment);
                    result = calendar.getTime();
                    break;
                }
                case MONTH: {
                    calendar.add(2, increment);
                    result = calendar.getTime();
                    break;
                }
                case YEAR: {
                    calendar.add(1, increment);
                    result = calendar.getTime();
                    break;
                }
            }
            return result;
        }
        return ref;
    }

    @Description(description="Retourne la date du lendemain.", parameters="date1:la date de r\u00e9f\u00e9rence \u00e0 d\u00e9caler d'un jour plus tard.\n")
    public static Date dayAfter(Date date) {
        if (date != null) {
            return BuiltinFunctions.delayedDate(date, 1, DateModification.DAY);
        }
        return date;
    }

    public static Date dayAfter(IMessageFieldDate date) {
        return BuiltinFunctions.dayAfter(BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    @Description(description="Retourne la date de la veille.", parameters="date1:la date de r\u00e9f\u00e9rence \u00e0 d\u00e9caler d'un jour plus t\u00f4t.\n")
    public static Date dayBefore(Date date) {
        if (date != null) {
            return BuiltinFunctions.delayedDate(date, -1, DateModification.DAY);
        }
        return date;
    }

    public static Date dayBefore(IMessageFieldDate date) {
        return BuiltinFunctions.dayBefore(BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    @Description(description="Retourne la date du dernier jour du mois qui correspond \u00e0 la date de r\u00e9f\u00e9rence.", parameters="date1:la date de r\u00e9f\u00e9rence.\n")
    public static Date lastDayOfMonth(Date date) {
        if (date != null) {
            LocalDate lastDayofCurrentMonth = Instant.ofEpochMilli(date.getTime()).atZone(defaultZoneId).toLocalDate().with(TemporalAdjusters.lastDayOfMonth());
            return Date.from(lastDayofCurrentMonth.atStartOfDay(defaultZoneId).toInstant());
        }
        return date;
    }

    public static Date lastDayOfMonth(IMessageFieldDate date) {
        return BuiltinFunctions.lastDayOfMonth(BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    @Description(description="Retourne la date du premier jour du mois qui correspond \u00e0 la date de r\u00e9f\u00e9rence.", parameters="date1:la date de r\u00e9f\u00e9rence.\n")
    public static Date firstDayOfMonth(Date date) {
        if (date != null) {
            LocalDate fistDayofCurrentMonth = Instant.ofEpochMilli(date.getTime()).atZone(defaultZoneId).toLocalDate().with(TemporalAdjusters.firstDayOfMonth());
            return Date.from(fistDayofCurrentMonth.atStartOfDay(defaultZoneId).toInstant());
        }
        return date;
    }

    public static Date firstDayOfMonth(IMessageFieldDate date) {
        return BuiltinFunctions.firstDayOfMonth(BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    @Description(description="Retourne le mois suivi de l'ann\u00e9e \u00e0 partir de la date de r\u00e9f\u00e9rence.", parameters="date1:la date de r\u00e9f\u00e9rence contenant l'ann\u00e9e et le mois \u00e0 extraire.\n")
    public static String monthAndYear(Date date) {
        if (date != null) {
            LocalDate localDate = Instant.ofEpochMilli(date.getTime()).atZone(defaultZoneId).toLocalDate();
            return localDate.format(DATE_FORMATER).substring(2);
        }
        return null;
    }

    public static String monthAndYear(IMessageFieldDate date) {
        return BuiltinFunctions.monthAndYear(BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    @Description(description="Retourne le mois \u00e0 partir de la date de r\u00e9f\u00e9rence.", parameters="date1:la date de r\u00e9f\u00e9rence contenant le mois \u00e0 extraire.\n")
    public static String month(Date date) {
        if (date != null) {
            LocalDate localDate = Instant.ofEpochMilli(date.getTime()).atZone(defaultZoneId).toLocalDate();
            return localDate.format(DATE_FORMATER).substring(2, 4);
        }
        return null;
    }

    public static String month(IMessageFieldDate date) {
        return BuiltinFunctions.month(BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    @Description(description="V\u00e9rifie si les mois des deux dates sont les m\u00eames.", parameters="date1:la premi\u00e8re date \u00e0 comparer,\ndate2:la seconde date \u00e0 comparer.\n")
    public static boolean sameMonth(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            return BuiltinFunctions.firstDayOfMonth(date1).equals(BuiltinFunctions.firstDayOfMonth(date2));
        }
        return date1 == date2;
    }

    public static boolean sameMonth(IMessageFieldDate date1, IMessageFieldDate date2) {
        return BuiltinFunctions.sameMonth(BuiltinFunctions.getValueOfMessageFieldDate(date1), BuiltinFunctions.getValueOfMessageFieldDate(date2));
    }

    @Description(description="V\u00e9rifie si l'intervalle de temps [d1, f1] inclut l'intervalle de temps [d2,f2].", parameters="date1:d\u00e9but de la premi\u00e8re p\u00e9riode d1,\ndate2:fin de la premi\u00e8re p\u00e9riode f1,\ndate3:d\u00e9but de la seconde p\u00e9riode d2,\ndate4:fin de la seconde p\u00e9riode f2.\n")
    public static boolean periodIncludes(Date d1, Date f1, Date d2, Date f2) {
        if (d1 != null && f1 != null && d2 != null && f2 != null) {
            return d1.compareTo(d2) <= 0 && d2.compareTo(f2) <= 0 && f2.compareTo(f1) <= 0;
        }
        return false;
    }

    public static boolean periodIncludes(IMessageFieldDate d1, IMessageFieldDate f1, IMessageFieldDate d2, IMessageFieldDate f2) {
        return BuiltinFunctions.periodIncludes(BuiltinFunctions.getValueOfMessageFieldDate(d1), BuiltinFunctions.getValueOfMessageFieldDate(f1), BuiltinFunctions.getValueOfMessageFieldDate(d2), BuiltinFunctions.getValueOfMessageFieldDate(f2));
    }

    @Description(description="Ajoute un nombre de jour \u00e0 une date.", parameters="date1:la date de r\u00e9f\u00e9rence \u00e0 modifier,\nnum1:le nombre de jours \u00e0 ajouter \u00e0 la date de r\u00e9f\u00e9rence.\n")
    public static Date addDays(Date date, BigDecimal days) {
        Date result = null;
        result = date == null ? null : (days == null ? date : BuiltinFunctions.delayedDate(date, days.intValueExact(), DateModification.DAY));
        return result;
    }

    public static Date addDays(IMessageFieldDate date, BigDecimal days) {
        return BuiltinFunctions.addDays(BuiltinFunctions.getValueOfMessageFieldDate(date), days);
    }

    @Description(description="Soustrait un nombre de jours \u00e0 une date.", parameters="date1:la date de r\u00e9f\u00e9rence \u00e0 d\u00e9caler,\nnum1:le nombre de jours \u00e0 soustraire \u00e0 la date de r\u00e9f\u00e9rence.\n")
    public static Date subDays(Date date, BigDecimal jours) {
        Date result = null;
        result = date == null ? null : (jours == null ? date : BuiltinFunctions.delayedDate(date, -jours.intValueExact(), DateModification.DAY));
        return result;
    }

    public static Date subDays(IMessageFieldDate date, BigDecimal jours) {
        return BuiltinFunctions.subDays(BuiltinFunctions.getValueOfMessageFieldDate(date), jours);
    }

    @Description(description="Ajoute un nombre de mois \u00e0 une date.", parameters="date1:la date de r\u00e9f\u00e9rence \u00e0 modifier,\nnum1:le nombre de mois \u00e0 ajouter \u00e0 la date de r\u00e9f\u00e9rence.\n")
    public static Date addMonths(Date date, BigDecimal months) {
        return BuiltinFunctions.delayedDate(date, months == null ? 0 : months.intValueExact(), DateModification.MONTH);
    }

    public static Date addMonths(IMessageFieldDate date, BigDecimal months) {
        return BuiltinFunctions.addMonths(BuiltinFunctions.getValueOfMessageFieldDate(date), months);
    }

    @Description(description="Retourne la date d'un mois plus tard.", parameters="date1:la date de r\u00e9f\u00e9rence \u00e0 d\u00e9caler d'un mois plus tard.\n")
    public static Date monthAfter(Date date) {
        return BuiltinFunctions.delayedDate(date, 1, DateModification.MONTH);
    }

    public static Date monthAfter(IMessageFieldDate date) {
        return BuiltinFunctions.monthAfter(BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    @Description(description="Retourne la date d'un mois plus t\u00f4t.", parameters="date1:la date de r\u00e9f\u00e9rence \u00e0 d\u00e9caler d'un mois plus t\u00f4t.\n")
    public static Date monthBefore(Date date) {
        return BuiltinFunctions.delayedDate(date, -1, DateModification.MONTH);
    }

    public static Date monthBefore(IMessageFieldDate date) {
        return BuiltinFunctions.monthBefore(BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    @Description(description="Retranche un nombre de mois \u00e0 une date.", parameters="date1:la date de r\u00e9f\u00e9rence \u00e0 modifier,\nnum1:le nombre de mois \u00e0 soustraire \u00e0 la date de r\u00e9f\u00e9rence.\n")
    public static Date subMonths(Date date, BigDecimal months) {
        return BuiltinFunctions.delayedDate(date, months == null ? 0 : -months.intValueExact(), DateModification.MONTH);
    }

    public static Date subMonths(IMessageFieldDate date, BigDecimal months) {
        return BuiltinFunctions.subMonths(BuiltinFunctions.getValueOfMessageFieldDate(date), months);
    }

    @Description(description="Ajoute un nombre d'ann\u00e9es \u00e0 une date.", parameters="date1:la date de r\u00e9f\u00e9rence \u00e0 d\u00e9caler,\nnum1:le nombre d'ann\u00e9e \u00e0 rajouter.\n")
    public static Date addYears(Date date, BigDecimal years) {
        return BuiltinFunctions.delayedDate(date, years == null ? 0 : years.intValueExact(), DateModification.YEAR);
    }

    public static Date addYears(IMessageFieldDate date, BigDecimal years) {
        return BuiltinFunctions.addYears(BuiltinFunctions.getValueOfMessageFieldDate(date), years);
    }

    @Description(description="Retourne la date d\u00e9cal\u00e9e d'une ann\u00e9e plus tard.", parameters="date1:la date de r\u00e9f\u00e9rence \u00e0 d\u00e9caler d'un an plus tard.\n")
    public static Date yearAfter(Date date) {
        return BuiltinFunctions.delayedDate(date, 1, DateModification.YEAR);
    }

    public static Date yearAfter(IMessageFieldDate date) {
        return BuiltinFunctions.yearAfter(BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    @Description(description="Retourne la date d\u00e9cal\u00e9e d'une ann\u00e9e plus t\u00f4t.", parameters="date1:la date de r\u00e9f\u00e9rence \u00e0 d\u00e9caler d'un an plus t\u00f4t.\n")
    public static Date yearBefore(Date date) {
        return BuiltinFunctions.delayedDate(date, -1, DateModification.YEAR);
    }

    public static Date yearBefore(IMessageFieldDate date) {
        return BuiltinFunctions.yearBefore(BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    @Description(description="Retranche un nombre d'ann\u00e9es d'une date.", parameters="date1:la date de r\u00e9f\u00e9rence \u00e0 d\u00e9caler,\nnum1:le nombre d'ann\u00e9e a retrancher.\n")
    public static Date subYears(Date date, BigDecimal years) {
        return BuiltinFunctions.delayedDate(date, years == null ? 0 : -years.intValueExact(), DateModification.YEAR);
    }

    public static Date subYears(IMessageFieldDate date, BigDecimal years) {
        return BuiltinFunctions.subYears(BuiltinFunctions.getValueOfMessageFieldDate(date), years);
    }

    @Description(description="Retourne l'ann\u00e9e depuis une date.", parameters="date1:la date de r\u00e9f\u00e9rence avec l'ann\u00e9e \u00e0 extraire.\n")
    public static BigDecimal yearFromDate(Date date) {
        if (date != null) {
            LocalDate localDate = Instant.ofEpochMilli(date.getTime()).atZone(defaultZoneId).toLocalDate();
            return BigDecimal.valueOf(localDate.getYear());
        }
        return null;
    }

    public static BigDecimal yearFromDate(IMessageFieldDate date) {
        return BuiltinFunctions.yearFromDate(BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    @Description(description="Retourne une date compos\u00e9e du jour, du mois et de l'ann\u00e9e \u00e0 partir d'une cha\u00eene de caract\u00e8re.", parameters="alphanum1:la date sous la forme d'une cha\u00eene de caract\u00e8re suivante un template.\nalphanum1:Template de la date \u00e0 parser (par exemple ddMMuuuu).\n")
    public static Date dateFromStringWithTemplate(String value, String strTemplate) {
        DateTimeFormatter dateFormater = DateTimeFormatter.ofPattern(strTemplate).withResolverStyle(ResolverStyle.STRICT);
        return BuiltinFunctions.dateFromString(value, dateFormater, strTemplate.length());
    }

    public static Date dateFromStringWithTemplate(IMessageFieldAlphanum value, String strTemplate) {
        return BuiltinFunctions.dateFromStringWithTemplate(BuiltinFunctions.getValueOfMessageFieldAlphanum(value), strTemplate);
    }

    @Description(description="Retourne une date compos\u00e9e du jour, du mois et de l'ann\u00e9e \u00e0 partir d'une cha\u00eene de caract\u00e8re.", parameters="alphanum1:la date sous la forme d'une cha\u00eene de caract\u00e8re suivante un template.\nalphanum1:Template de la date \u00e0 parser (par exemple ddMMuuuu).\n")
    public static Date dateFromString(String value) {
        return BuiltinFunctions.dateFromString(value, DATE_FORMATER, 8);
    }

    private static Date dateFromString(String value, DateTimeFormatter dateFormater, int size) {
        Date result = null;
        if (value != null && value.length() == size) {
            try {
                LocalDate localDate = LocalDate.parse(value, dateFormater);
                result = Date.from(localDate.atStartOfDay(defaultZoneId).toInstant());
            }
            catch (Exception exception) {
                result = null;
            }
        }
        return result;
    }

    public static Date dateFromString(IMessageFieldAlphanum value) {
        return BuiltinFunctions.dateFromString(BuiltinFunctions.getValueOfMessageFieldAlphanum(value));
    }

    @Description(description="Renvoie l'ann\u00e9e contenu dans une date exprim\u00e9e par un nombre, qui doit \u00eatre au format JJMMAAAA.Cf.{@link <a href=\"http://www.net-entreprises.fr/html/documents/N4DS_cahier-technique_V01X06.pdf\">Cachier technique de la norme \"N4DS\"</a>pour la rubrique S30.G01.00.009 (page 100)}", parameters="num1:la date exprim\u00e9e par un BigDecimal de 8 chiffres.\n")
    public static BigDecimal yearFromNum(BigDecimal date) {
        return date == null ? null : date.remainder(BigDecimal.valueOf(10000L));
    }

    public static BigDecimal yearFromNum(IMessageFieldNum date) {
        return BuiltinFunctions.yearFromNum(BuiltinFunctions.getValueOfMessageFieldNum(date));
    }

    @Description(description="Renvoie la cha\u00eene form\u00e9e des caract\u00e8res situ\u00e9s aux position 2 et 3 de value", parameters="alphanum1:la valeur d'un NIR.\n")
    public static String nirYear(String value) {
        return value == null || value.length() != 13 ? null : value.substring(1, 3);
    }

    public static String nirYear(IMessageFieldAlphanum value) {
        return BuiltinFunctions.nirYear(BuiltinFunctions.getValueOfMessageFieldAlphanum(value));
    }

    @Description(description="Renvoie le nombre de jours entre 2 dates.", parameters="date1:la date de d\u00e9but,\ndate2:la date de fin.\n")
    public static BigDecimal diffDate(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            long day = ChronoUnit.DAYS.between(date1.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            return BigDecimal.valueOf(day);
        }
        return BigDecimal.ONE;
    }

    public static BigDecimal diffDate(IMessageFieldDate date1, IMessageFieldDate date2) {
        return BuiltinFunctions.diffDate(BuiltinFunctions.getValueOfMessageFieldDate(date1), BuiltinFunctions.getValueOfMessageFieldDate(date2));
    }

    @Description(description="Indique s'il y a un chevauchement entre [date1, date2] et [date3, date4], y compris si le chevauchement n'est que d'une journ\u00e9e.", parameters="date1:la date de d\u00e9but de la premi\u00e8re p\u00e9riode,\ndate2:la date de fin de la premi\u00e8re p\u00e9riode,\ndate3:la date de d\u00e9but de la seconde p\u00e9riode,/ndate4:la date de fin de la seconde p\u00e9riode./n")
    public static boolean overlapPeriod(Date deb1, Date fin1, Date deb2, Date fin2) {
        if (deb1 != null && fin1 != null && deb2 != null && fin2 != null) {
            return deb1.compareTo(fin2) <= 0 && deb2.compareTo(fin1) <= 0;
        }
        return false;
    }

    public static boolean overlapPeriod(IMessageFieldDate deb1, IMessageFieldDate fin1, IMessageFieldDate deb2, IMessageFieldDate fin2) {
        return BuiltinFunctions.overlapPeriod(BuiltinFunctions.getValueOfMessageFieldDate(deb1), BuiltinFunctions.getValueOfMessageFieldDate(fin1), BuiltinFunctions.getValueOfMessageFieldDate(deb2), BuiltinFunctions.getValueOfMessageFieldDate(fin2));
    }

    public static boolean isPresent(Object rubrique) {
        return rubrique != null;
    }

    public static boolean isAbsent(Object rubrique) {
        return rubrique == null;
    }

    @Description(description="Indique si une rubrique est pr\u00e9sente ou non.", parameters="node1:la liste des rubriques/blocs dont la pr\u00e9sence est \u00e0 verifier./n")
    public static boolean isPresent(Iterable<?> iterable) {
        return iterable != null && iterable.iterator().hasNext();
    }

    @Description(description="Indique si une rubrique est absente ou non.", parameters="node1:la liste des rubriques/blocs dont la pr\u00e9sence est \u00e0 verifier./n")
    public static boolean isAbsent(Iterable<?> iterable) {
        return iterable == null || !iterable.iterator().hasNext();
    }

    @Description(description="Retourne la taille de la cha\u00eene de caract\u00e8re.", parameters="alphanum1:la cha\u00eene de caract\u00e8re dont on veut obtenir la taille./n")
    public static BigDecimal stringLength(String value) {
        return value == null ? BigDecimal.ZERO : BigDecimal.valueOf(value.length());
    }

    public static BigDecimal stringLength(IMessageFieldAlphanum value) {
        return BuiltinFunctions.stringLength(BuiltinFunctions.getValueOfMessageFieldAlphanum(value));
    }

    @Description(description="V\u00e9rifie qu'une cha\u00eene de caract\u00e8res repr\u00e9sente bien un e-mail.Cf.{@link <a href=\"http://www.net-entreprises.fr/html/documents/N4DS_cahier-technique_V01X06.pdf\">Cachier technique de la norme \"N4DS\"</a>pour la rubrique S30.G01.00.019 (page 101)}", parameters="alphanum1:la cha\u00eene de caract\u00e8re \u00e0 v\u00e9rifier./n")
    public static boolean isEmail(String value) {
        return value == null ? false : value.matches("\\w([\\.\\-_]?\\w)*@\\w([\\.\\-_]?\\w)*\\.\\w([\\.\\-_]?\\w)*");
    }

    public static boolean isEmail(IMessageFieldAlphanum value) {
        return BuiltinFunctions.isEmail(BuiltinFunctions.getValueOfMessageFieldAlphanum(value));
    }

    @Description(description="Indique si date est comprise dans [debut, fin] (bornes incluses).", parameters="date1:la date \u00e0 contr\u00f4ler,/ndate2:la date de d\u00e9but de p\u00e9riode,\nla date de fin de p\u00e9riode.\n")
    public static boolean isInPeriod(Date date, Date debut, Date fin) {
        if (date != null && debut != null && fin != null) {
            return debut.compareTo(date) <= 0 && date.compareTo(fin) <= 0;
        }
        return false;
    }

    public static boolean isInPeriod(IMessageFieldDate date, IMessageFieldDate debut, IMessageFieldDate fin) {
        return BuiltinFunctions.isInPeriod(BuiltinFunctions.getValueOfMessageFieldDate(date), BuiltinFunctions.getValueOfMessageFieldDate(debut), BuiltinFunctions.getValueOfMessageFieldDate(fin));
    }

    @Description(description="V\u00e9rifie que la cha\u00eene correspond \u00e0 la regex.", parameters="alphanum1:la cha\u00eene de caract\u00e8re \u00e0 v\u00e9rifier,/nalphanum2:l'expression REGEXP.\n")
    public static boolean matchesString(String value, String regex) {
        return value == null ? false : (regex == null ? false : value.matches(regex));
    }

    public static boolean matchesString(IMessageFieldAlphanum value, String regex) {
        return BuiltinFunctions.matchesString(BuiltinFunctions.getValueOfMessageFieldAlphanum(value), regex);
    }

    @Description(description="Indique si un nombre v\u00e9rifie l'algorithme de Luhn.", parameters="alphanum1:la cha\u00eene de caract\u00e8re \u00e0 verifier,/nnum1:longueur de la cha\u00eene \u00e0 v\u00e9rifier.\n")
    public static boolean isLuhnValid(String value, int count) {
        if (value == null) {
            return true;
        }
        if (value.length() >= count) {
            int val;
            int sum = 0;
            int i = count - 1;
            while (i >= 0) {
                val = Character.digit(value.charAt(i), 10);
                if (val < 0) {
                    return false;
                }
                sum += val;
                i -= 2;
            }
            i = count - 2;
            while (i >= 0) {
                val = Character.digit(value.charAt(i), 10) * 2;
                if (val < 0) {
                    return false;
                }
                sum += val > 9 ? val - 9 : val;
                i -= 2;
            }
            return sum == 0 ? false : sum % 10 == 0;
        }
        return false;
    }

    @Description(description="V\u00e9rifie que toutes les valeurs de la liste sont diff\u00e9rentes.", parameters="node1:la liste des rubriques \u00e0 v\u00e9rifier.\n")
    public static boolean allDiff(Iterable<? extends IMessageField<?>> rubriques) {
        if (rubriques == null) {
            return false;
        }
        HashSet values = new HashSet();
        for (IMessageField<?> rubrique : rubriques) {
            Object value = rubrique.getValue();
            if (values.contains(value)) {
                return false;
            }
            values.add(value);
        }
        return true;
    }

    @Description(description="Indique si une cha\u00eene de caract\u00e8res commence par une autre.", parameters="alphanum1:la cha\u00eene de caract\u00e8re \u00e0 v\u00e9rifier,\nalphanum2:le d\u00e9but de cha\u00eene de caract\u00e8re \u00e0 retrouver.\n")
    public static boolean startsWith(String s1, String s2) {
        return s1 == null ? false : (s2 == null ? false : s1.startsWith(s2));
    }

    public static boolean startsWith(IMessageFieldAlphanum s1, IMessageFieldAlphanum s2) {
        return BuiltinFunctions.startsWith(BuiltinFunctions.getValueOfMessageFieldAlphanum(s1), BuiltinFunctions.getValueOfMessageFieldAlphanum(s2));
    }

    public static boolean startsWith(IMessageFieldAlphanum s1, String s2) {
        return BuiltinFunctions.startsWith(BuiltinFunctions.getValueOfMessageFieldAlphanum(s1), s2);
    }

    @Description(description="Extraction d'une partie d'un nombre.", parameters="num1:valeur num\u00e9rique sur laquelle on r\u00e9alise l'extraction,\nnum2:position de d\u00e9but de l'extraction (1 pour le premier caract\u00e8re),\nnum3:longueur du nombre \u00e0 extraire (ex.:digit(1234,1,2)=12).")
    public static BigDecimal digit(BigDecimal value, BigDecimal start, BigDecimal length) {
        return value == null ? null : BuiltinFunctions.digitStr(value.toPlainString(), start, length);
    }

    public static BigDecimal digit(IMessageFieldNum value, BigDecimal start, BigDecimal length) {
        return BuiltinFunctions.digit(BuiltinFunctions.getValueOfMessageFieldNum(value), start, length);
    }

    @Description(description="Retourne un num\u00e9rique qui correspond \u00e0 l'extraction d'une partie d'une cha\u00eene de caract\u00e8re.", parameters="alphanum1:cha\u00eene de caract\u00e8re contenant le nombre \u00e0 extraire,\nnum2:position de d\u00e9but de l'extraction (1 pour le premier caract\u00e8re),\nnum3:longueur du nombre \u00e0 extraire (ex.:digitStr(1234,1,2)=12).")
    public static BigDecimal digitStr(String value, BigDecimal start, BigDecimal length) {
        try {
            int debut = start.intValueExact() - 1;
            return new BigDecimal(value.substring(debut, debut + length.intValueExact()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static BigDecimal digitStr(IMessageFieldAlphanum value, BigDecimal start, BigDecimal length) {
        return BuiltinFunctions.digitStr(BuiltinFunctions.getValueOfMessageFieldAlphanum(value), start, length);
    }

    @Description(description="Convertit la cha\u00eene de caract\u00e8re en BigDecimal.", parameters="alphanum1:cha\u00eene de caract\u00e8re \u00e0 convertir en BigDecimal.\n")
    public static BigDecimal doubleFromStr(String value) {
        return value == null ? null : new BigDecimal(value);
    }

    public static BigDecimal doubleFromStr(IMessageFieldAlphanum value) {
        return BuiltinFunctions.doubleFromStr(BuiltinFunctions.getValueOfMessageFieldAlphanum(value));
    }

    @Description(description="Retourne une nouvelle cha\u00eene qui est une sous-cha\u00eene de cette cha\u00eene. La cha\u00eene commence \u00e0 l'index sp\u00e9cifi\u00e9 et s'\u00e9tend sur le caract\u00e8re \u00e0 l'index endIndex - 1.", parameters="alphanum1:cha\u00eene de caract\u00e8re portant l'extraction,\nnum1:position de d\u00e9but d'extraction (1 pour la premi\u00e8re position),num2:longueur de la cha\u00eene \u00e0 extraire (1 pour un caract\u00e8re, ex.:substring('test', 1,2)='te').\n")
    public static String substring(String value, BigDecimal start, BigDecimal length) {
        try {
            int debut = start.intValueExact() - 1;
            int fin = debut + length.intValueExact();
            return value.substring(debut, fin);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String substring(IMessageFieldAlphanum value, BigDecimal start, BigDecimal length) {
        return BuiltinFunctions.substring(BuiltinFunctions.getValueOfMessageFieldAlphanum(value), start, length);
    }

    @Description(description="Concatenation de deux cha\u00eenes de caract\u00e8res.", parameters="alphanum1:cha\u00eene de caract\u00e8re du d\u00e9but,\nalphanum1:cha\u00eene de caract\u00e8re de fin.\n")
    public static String concat(String value1, String value2) {
        if (value1 == null || value2 == null) {
            return value1 == null ? value2 : value1;
        }
        return String.valueOf(value1) + value2;
    }

    public static String concat(IMessageFieldAlphanum value1, IMessageFieldAlphanum value2) {
        return BuiltinFunctions.concat(BuiltinFunctions.getValueOfMessageFieldAlphanum(value1), BuiltinFunctions.getValueOfMessageFieldAlphanum(value2));
    }

    public static String concat(IMessageFieldAlphanum value1, String value2) {
        return BuiltinFunctions.concat(BuiltinFunctions.getValueOfMessageFieldAlphanum(value1), value2);
    }

    @Description(description="Retourne le nombre d'\u00e9l\u00e9ments contenu par la liste pass\u00e9e en argument.", parameters="node1:liste de fields.\n")
    public static BigDecimal num(Iterable<? extends IMessageField<?>> list) {
        if (list == null) {
            return new BigDecimal(0);
        }
        List rubList = StreamSupport.stream(list.spliterator(), false).collect(Collectors.toList());
        return new BigDecimal(rubList.size());
    }

    @Description(description="Retourne le nombre d'\u00e9l\u00e9ments contenu par la liste de MessageBlock pass\u00e9e en argument.", parameters="node1:liste de MessageBlock.\n")
    public static BigDecimal numBlock(Iterable<IMessageBlock> list) {
        if (list == null) {
            return new BigDecimal(0);
        }
        List blockList = StreamSupport.stream(list.spliterator(), false).collect(Collectors.toList());
        return new BigDecimal(blockList.size());
    }

    @Description(description="Retourne la valeur minimale de la liste pass\u00e9e en argument.", parameters="node1:liste de fields de type num\u00e9rique.\n")
    public static BigDecimal min(Iterable<? extends IMessageFieldNum> nums) {
        try {
            BigDecimal min = null;
            for (IMessageFieldNum iMessageFieldNum : nums) {
                min = min == null ? (BigDecimal)iMessageFieldNum.getValue() : ((BigDecimal)iMessageFieldNum.getValue()).min(min);
            }
            return min;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Description(description="Retourne la valeur maximale de la liste pass\u00e9e en argument.", parameters="node1:liste de fields de type num\u00e9rique.\n")
    public static BigDecimal max(Iterable<? extends IMessageFieldNum> nums) {
        try {
            BigDecimal max = null;
            for (IMessageFieldNum iMessageFieldNum : nums) {
                max = max == null ? (BigDecimal)iMessageFieldNum.getValue() : ((BigDecimal)iMessageFieldNum.getValue()).max(max);
            }
            return max;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Description(description="Retourne la moyenne des \u00e9l\u00e9ments de la liste pass\u00e9e en argument.", parameters="node1:liste de fields de type num\u00e9rique.\n")
    public static BigDecimal average(Iterable<? extends IMessageFieldNum> nums) {
        try {
            double sum = 0.0;
            int nbr = 0;
            for (IMessageFieldNum iMessageFieldNum : nums) {
                ++nbr;
                sum += ((BigDecimal)iMessageFieldNum.getValue()).doubleValue();
            }
            return new BigDecimal(sum / (double)nbr);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Description(description="Retourne la multiplication des \u00e9l\u00e9ments de la liste pass\u00e9e en argument.", parameters="node1:liste de fields de type num\u00e9rique.\n")
    public static BigDecimal mult(Iterable<? extends IMessageFieldNum> nums) {
        double mult = 1.0;
        try {
            for (IMessageFieldNum iMessageFieldNum : nums) {
                mult *= ((BigDecimal)iMessageFieldNum.getValue()).doubleValue();
            }
        }
        catch (Exception exception) {}
        return BigDecimal.valueOf(mult);
    }

    @Description(description="Retourne la somme des \u00e9l\u00e9ments de la liste pass\u00e9e en argument.", parameters="node1:liste de fields de type num\u00e9rique.\n")
    public static BigDecimal sigma(Iterable<? extends IMessageFieldNum> nums) {
        if (nums == null) {
            return BigDecimal.valueOf(0L);
        }
        Iterator<? extends IMessageFieldNum> iterator = nums.iterator();
        if (!iterator.hasNext()) {
            return BigDecimal.valueOf(0L);
        }
        int sum = 0;
        for (IMessageFieldNum iMessageFieldNum : nums) {
            sum += ((BigDecimal)iMessageFieldNum.getValue()).intValue();
        }
        return BigDecimal.valueOf(sum);
    }

    @Description(description="Retourne la cha\u00eene de taille minimale \u00e0 partir de la liste pass\u00e9e en argument.", parameters="node1:liste de fields de type alphanum\u00e9rique.\n")
    public static String minLength(Iterable<? extends IMessageFieldAlphanum> alphas) {
        String result = null;
        try {
            for (IMessageFieldAlphanum iMessageFieldAlphanum : alphas) {
                if (result != null && result.length() <= ((String)iMessageFieldAlphanum.getValue()).length()) continue;
                result = (String)iMessageFieldAlphanum.getValue();
            }
        }
        catch (Exception exception) {}
        return result;
    }

    @Description(description="Retourne la cha\u00eene de taille maximale dans la liste pass\u00e9e en argument.", parameters="node1:liste de fields de type alphanum\u00e9rique.\n")
    public static String maxLength(Iterable<? extends IMessageFieldAlphanum> alphas) {
        String result = null;
        try {
            for (IMessageFieldAlphanum iMessageFieldAlphanum : alphas) {
                if (result != null && result.length() >= ((String)iMessageFieldAlphanum.getValue()).length()) continue;
                result = (String)iMessageFieldAlphanum.getValue();
            }
        }
        catch (Exception exception) {}
        return result;
    }

    @Description(description="Retourne une cha\u00eene repr\u00e9sentant la concat\u00e9nation des valeurs des \u00e9l\u00e9ments de la liste pass\u00e9e en argument s\u00e9par\u00e9e par la valeur du s\u00e9parateur pass\u00e9 en argument.", parameters="node1:liste de fields de type alphanum\u00e9rique,\nalphanum1:cha\u00eene de caract\u00e8re utilis\u00e9e pour s\u00e9parer chaque valeur concat\u00e9n\u00e9e.\n")
    public static String concatList(Iterable<? extends IMessageFieldAlphanum> alphas, String separator) {
        String sep = separator;
        if (sep == null) {
            sep = "";
        }
        try {
            boolean emptyList = true;
            StringBuilder sb = new StringBuilder();
            for (IMessageFieldAlphanum iMessageFieldAlphanum : alphas) {
                emptyList = false;
                if (!sb.toString().isEmpty()) {
                    sb.append(sep);
                }
                sb.append(iMessageFieldAlphanum.getValueAsString());
            }
            return emptyList ? null : sb.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Description(description="Retourne la cha\u00eene de premi\u00e8re position dans la liste pass\u00e9e en argument tri\u00e9e selon son ordre lexicographique.", parameters="node1:liste de fields de type alphanum\u00e9rique.\n")
    public static String lexicalMin(Iterable<? extends IMessageFieldAlphanum> alphas) {
        try {
            Comparator<IMessageFieldAlphanum> comparator = new Comparator<IMessageFieldAlphanum>(){

                @Override
                public int compare(IMessageFieldAlphanum alpha1, IMessageFieldAlphanum alpha2) {
                    return alpha1.getValueAsString().compareTo(alpha2.getValueAsString());
                }
            };
            IMessageField result = null;
            for (IMessageFieldAlphanum iMessageFieldAlphanum : alphas) {
                if (result != null && comparator.compare(iMessageFieldAlphanum, (IMessageFieldAlphanum)result) >= 0) continue;
                result = iMessageFieldAlphanum;
            }
            return (String)result.getValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Description(description="Retourne la cha\u00eene de la derni\u00e8re position dans la liste pass\u00e9e en argument tri\u00e9e selon son ordre lexicographique.", parameters="node1:liste de fields de type alphanum\u00e9rique.\n")
    public static String lexicalMax(Iterable<? extends IMessageFieldAlphanum> alphas) {
        try {
            Comparator<IMessageFieldAlphanum> comparator = new Comparator<IMessageFieldAlphanum>(){

                @Override
                public int compare(IMessageFieldAlphanum alpha1, IMessageFieldAlphanum alpha2) {
                    return alpha1.getValueAsString().compareTo(alpha2.getValueAsString());
                }
            };
            IMessageField result = null;
            for (IMessageFieldAlphanum iMessageFieldAlphanum : alphas) {
                if (result != null && comparator.compare(iMessageFieldAlphanum, (IMessageFieldAlphanum)result) <= 0) continue;
                result = iMessageFieldAlphanum;
            }
            return (String)result.getValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Description(description="Retourne une cha\u00eene repr\u00e9sentant la concat\u00e9nation des valeurs des \u00e9l\u00e9ments de la liste pass\u00e9e en argument tri\u00e9e selon son ordre lexicographique et s\u00e9par\u00e9es par la valeur du s\u00e9parateur pass\u00e9 en argument.", parameters="node1:liste de fields de type alphanum\u00e9rique,\nalphanum1:cha\u00eene de caract\u00e8re utilis\u00e9e pour s\u00e9parer chaque valeur concat\u00e9n\u00e9e.\n")
    public static String lexicalConcat(Iterable<? extends IMessageFieldAlphanum> alphas, String separator) {
        ArrayList<IMessageFieldAlphanum> list = new ArrayList<IMessageFieldAlphanum>();
        try {
            for (IMessageFieldAlphanum iMessageFieldAlphanum : alphas) {
                list.add(iMessageFieldAlphanum);
            }
            Collections.sort(list, new Comparator<IMessageFieldAlphanum>(){

                @Override
                public int compare(IMessageFieldAlphanum alpha1, IMessageFieldAlphanum alpha2) {
                    return alpha1.getValueAsString().compareTo(alpha2.getValueAsString());
                }
            });
            return BuiltinFunctions.concatList(list, separator);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Description(description="Retourne 'vrai' si l'\u00e9l\u00e9ment pass\u00e9 en argument existe dans la liste pass\u00e9e en argument, 'faux' sinon.", parameters="node1:liste de fields de type alphanum\u00e9rique,\nalphanum1:cha\u00eene de caract\u00e8re \u00e0 rechercher.\n")
    public static boolean containsAlpha(Iterable<? extends IMessageFieldAlphanum> alphas, String alpha) {
        if (alpha == null) {
            return true;
        }
        boolean result = false;
        try {
            for (IMessageFieldAlphanum iMessageFieldAlphanum : alphas) {
                if (!iMessageFieldAlphanum.getValueAsString().equals(alpha)) continue;
                result = true;
                break;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    public static boolean containsAlpha(Iterable<? extends IMessageFieldAlphanum> alphas, IMessageFieldAlphanum alpha) {
        return BuiltinFunctions.containsAlpha(alphas, BuiltinFunctions.getValueOfMessageFieldAlphanum(alpha));
    }

    @Description(description="Test si la liste des Fields ne contient que des valeurs uniques.", parameters="node1:liste de fields de type alphanum\u00e9rique.\n")
    public static boolean unique(Iterable<? extends IMessageFieldAlphanum> alphas) {
        boolean result = true;
        if (alphas != null) {
            HashSet<String> set = new HashSet<String>();
            for (IMessageFieldAlphanum iMessageFieldAlphanum : alphas) {
                if (set.add((String)iMessageFieldAlphanum.getValue())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private static boolean uniqueConcateXValues(Iterable<? extends IMessageBlock> blocks, int ... idx) {
        boolean result = true;
        if (blocks != null) {
            HashSet<String> set = new HashSet<String>();
            for (IMessageBlock iMessageBlock : blocks) {
                StringBuilder concateStr = new StringBuilder();
                boolean hasNullField = false;
                int i = 0;
                while (i < idx.length) {
                    int currentIdx = idx[i];
                    IMessageField<?> msgField = iMessageBlock.getField(currentIdx);
                    if (msgField != null) {
                        concateStr.append(msgField.getValueAsString());
                    } else {
                        hasNullField = true;
                    }
                    ++i;
                }
                if (hasNullField || set.add(concateStr.toString())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Description(description="Test si la concatenation des 5 fields de la liste des blocks est unique.", parameters="node1:la liste de blocs \u00e0 v\u00e9rifiers,\nalphanum1:fullQualifiedId du premier field,\nalphanum1:fullQualifiedId du second field,\nalphanum1:fullQualifiedId du troisi\u00e8me field,\nalphanum1:fullQualifiedId du quatri\u00e8me field,\nalphanum1:fullQualifiedId du cinqui\u00e8me field.\n")
    public static boolean uniqueConcate5Values(StandardAccessor modelAccessor, Iterable<? extends IMessageBlock> blocks, String fqidFieldIdx1, String fqidFieldIdx2, String fqidFieldIdx3, String fqidFieldIdx4, String fqidFieldIdx5) {
        MessageElementDescription messageElementDescription;
        boolean result = true;
        if (blocks != null && blocks.iterator().hasNext() && (messageElementDescription = blocks.iterator().next().getStandardBlockDescription()) instanceof BlockDescription) {
            BlockDescription blockDescription = (BlockDescription)messageElementDescription;
            FieldDescription fieldDescription1 = modelAccessor.getFieldDescription(fqidFieldIdx1);
            int idx1 = blockDescription.getFields().indexOf(fieldDescription1);
            FieldDescription fieldDescription2 = modelAccessor.getFieldDescription(fqidFieldIdx2);
            int idx2 = blockDescription.getFields().indexOf(fieldDescription2);
            FieldDescription fieldDescription3 = modelAccessor.getFieldDescription(fqidFieldIdx3);
            int idx3 = blockDescription.getFields().indexOf(fieldDescription3);
            FieldDescription fieldDescription4 = modelAccessor.getFieldDescription(fqidFieldIdx4);
            int idx4 = blockDescription.getFields().indexOf(fieldDescription4);
            FieldDescription fieldDescription5 = modelAccessor.getFieldDescription(fqidFieldIdx5);
            int idx5 = blockDescription.getFields().indexOf(fieldDescription5);
            result = BuiltinFunctions.uniqueConcateXValues(blocks, idx1, idx2, idx3, idx4, idx5);
        }
        return result;
    }

    @Description(description="Retourne la valeur minimale de la liste de Date pass\u00e9e en argument.", parameters="node1:liste de fields de type date.\n")
    public static Date minDate(Iterable<? extends IMessageFieldDate> dates) {
        Date min = null;
        try {
            for (IMessageFieldDate iMessageFieldDate : dates) {
                if (min != null && !((Date)iMessageFieldDate.getValue()).before(min)) continue;
                min = (Date)iMessageFieldDate.getValue();
            }
            return min;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Description(description="Retourne la valeur maximale de la liste de Date pass\u00e9e en argument.", parameters="node1:liste de fields de type date.\n")
    public static Date maxDate(Iterable<? extends IMessageFieldDate> dates) {
        Date max = null;
        try {
            for (IMessageFieldDate iMessageFieldDate : dates) {
                if (max != null && !((Date)iMessageFieldDate.getValue()).after(max)) continue;
                max = (Date)iMessageFieldDate.getValue();
            }
            return max;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Description(description="Retourne 'vrai' si l'\u00e9l\u00e9ment pass\u00e9 en argument existe dans la liste pass\u00e9e en argument, 'faux' sinon.", parameters="node1:liste de fields de type date,\ndate1:la date \u00e0 rechercher.\n")
    public static boolean containsDate(Iterable<? extends IMessageFieldDate> dates, Date date) {
        if (dates == null) {
            return false;
        }
        if (date == null) {
            return true;
        }
        for (IMessageFieldDate iMessageFieldDate : dates) {
            if (!((Date)iMessageFieldDate.getValue()).equals(date)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDate(Iterable<? extends IMessageFieldDate> dates, IMessageFieldDate date) {
        return BuiltinFunctions.containsDate(dates, BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    public static boolean isInExternalRef(StandardAccessor modelAccessor, String referentialName, String value) {
        String columnId = null;
        String fileName = null;
        if (referentialName.contains("#")) {
            int colmnIdSep = referentialName.indexOf(35);
            columnId = referentialName.substring(colmnIdSep + 1);
            try {
                Integer.parseInt(columnId);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            int fileNameStart = 0;
            if (referentialName.startsWith("csv://")) {
                fileNameStart = "csv://".length();
            }
            if (!(fileName = referentialName.substring(fileNameStart, colmnIdSep)).endsWith(".csv")) {
                fileName = String.valueOf(fileName) + ".csv";
            }
        } else {
            return false;
        }
        Set modelAccessorSetValues = modelAccessor.getReferential(fileName, columnId);
        return modelAccessorSetValues != null && modelAccessorSetValues.contains(value);
    }

    public static boolean isInExternalRef(StandardAccessor modelAccessor, String referentialName, IMessageFieldAlphanum value) {
        DataTypeUtil dataTypeUtil = new DataTypeUtil();
        boolean isFilteredValue = dataTypeUtil.isFilteredValue(BuiltinFunctions.getValueOfMessageFieldAlphanum(value), value.getStandardFieldDescription().getDataType());
        return BuiltinFunctions.isInExternalRef(modelAccessor, referentialName, BuiltinFunctions.getValueOfMessageFieldAlphanum(value)) && !isFilteredValue;
    }

    @Description(description="Retourne la premi\u00e8re date de la liste de Date pass\u00e9e en argument.", parameters="node1:liste de fields de type date.\n")
    public static Date firstDate(Iterable<? extends IMessageFieldDate> dates) {
        Iterator<? extends IMessageFieldDate> iterator;
        if (dates != null && (iterator = dates.iterator()).hasNext()) {
            IMessageFieldDate rub = iterator.next();
            return (Date)rub.getValue();
        }
        return null;
    }

    @Description(description="Retourne la premi\u00e8re valeur num\u00e9rique de la liste de num\u00e9rique pass\u00e9e en argument.", parameters="node1:liste de fields de type num\u00e9rique.\n")
    public static BigDecimal firstNum(Iterable<? extends IMessageFieldNum> nums) {
        Iterator<? extends IMessageFieldNum> iterator;
        if (nums != null && (iterator = nums.iterator()).hasNext()) {
            IMessageFieldNum rub = iterator.next();
            return (BigDecimal)rub.getValue();
        }
        return null;
    }

    @Description(description="Retourne la premi\u00e8re valeur alphanum\u00e9rique de la liste d'alphanum\u00e9rique pass\u00e9e en argument.", parameters="node1:liste de fields de type alphanum\u00e9rique.\n")
    public static String firstAlphaNum(Iterable<? extends IMessageFieldAlphanum> alphaNums) {
        Iterator<? extends IMessageFieldAlphanum> iterator;
        if (alphaNums != null && (iterator = alphaNums.iterator()).hasNext()) {
            IMessageFieldAlphanum rub = iterator.next();
            return (String)rub.getValue();
        }
        return null;
    }

    @Description(description="Retourne la derni\u00e8re date de la liste de date pass\u00e9e en argument.", parameters="node1:liste de fields de type date.\n")
    public static Date lastDate(Iterable<? extends IMessageFieldDate> dates) {
        Date resultDate = null;
        if (dates != null) {
            for (IMessageFieldDate iMessageFieldDate : dates) {
                resultDate = (Date)iMessageFieldDate.getValue();
            }
        }
        return resultDate;
    }

    @Description(description="Retourne la derni\u00e8re valeur num\u00e9rique de la liste de num\u00e9rique pass\u00e9e en argument.", parameters="node1:liste de fields de type num\u00e9rique.\n")
    public static BigDecimal lastNum(Iterable<? extends IMessageFieldNum> nums) {
        BigDecimal resultNum = null;
        if (nums != null) {
            for (IMessageFieldNum iMessageFieldNum : nums) {
                resultNum = (BigDecimal)iMessageFieldNum.getValue();
            }
        }
        return resultNum;
    }

    @Description(description="Retourne la derni\u00e8re valeur alphanum\u00e9rique de la liste d'alphanum\u00e9rique pass\u00e9e en argument.", parameters="node1:liste de fields de type alphanum\u00e9rique.\n")
    public static String lastAlphaNum(Iterable<? extends IMessageFieldAlphanum> alphaNums) {
        String resultAplhaNum = null;
        if (alphaNums != null) {
            for (IMessageFieldAlphanum iMessageFieldAlphanum : alphaNums) {
                resultAplhaNum = (String)iMessageFieldAlphanum.getValue();
            }
        }
        return resultAplhaNum;
    }

    @Description(description="Retourne la date de la liste \u00e0 une position sp\u00e9cifique pass\u00e9e en argument.", parameters="node1:liste de fields de type date,\nnum1:indice de la date \u00e0 extraire depuis la liste qui commence \u00e0 0 pour le premier \u00e9l\u00e9ment.\n")
    public static Date dateAtIndex(Iterable<? extends IMessageFieldDate> dates, int index) {
        if (dates != null) {
            int i = 0;
            for (IMessageFieldDate iMessageFieldDate : dates) {
                if (i == index) {
                    return (Date)iMessageFieldDate.getValue();
                }
                ++i;
            }
        }
        return null;
    }

    @Description(description="Retourne la valeur num\u00e9rique de la liste \u00e0 une position sp\u00e9cifique pass\u00e9e en argument.", parameters="node1:liste de fields de type num\u00e9rique,\nnum1:indice du num\u00e9rique \u00e0 extraire depuis la liste qui commence \u00e0 0 pour le premier \u00e9l\u00e9ment.\n")
    public static BigDecimal numAtIndex(Iterable<? extends IMessageFieldNum> nums, int index) {
        if (nums != null) {
            int i = 0;
            for (IMessageFieldNum iMessageFieldNum : nums) {
                if (i == index) {
                    return (BigDecimal)iMessageFieldNum.getValue();
                }
                ++i;
            }
        }
        return null;
    }

    @Description(description="Retourne la valeur alphanum\u00e9rique de la liste \u00e0 une position sp\u00e9cifique pass\u00e9e en argument.", parameters="node1:liste de fields de type alphanum\u00e9rique,\nnum1:indice de l'alphanum\u00e9rique \u00e0 extraire depuis la liste qui commence \u00e0 0 pour le premier \u00e9l\u00e9ment.\n")
    public static String alphaNumAtIndex(Iterable<? extends IMessageFieldAlphanum> alphaNums, int index) {
        if (alphaNums != null) {
            int i = 0;
            for (IMessageFieldAlphanum iMessageFieldAlphanum : alphaNums) {
                if (i == index) {
                    return (String)iMessageFieldAlphanum.getValue();
                }
                ++i;
            }
        }
        return null;
    }

    @Description(description="Retourne la valeur alphanum\u00e9rique d'un Field de type Alphanum pass\u00e9 en argument.", parameters="alphaNum1:field de type alphanum\u00e9rique.\n")
    public static String getValueOfMessageFieldAlphanum(IMessageFieldAlphanum alphaNum) {
        if (alphaNum != null) {
            return (String)alphaNum.getValue();
        }
        return null;
    }

    @Description(description="Retourne la valeur num\u00e9rique d'un Field de type Num pass\u00e9 en argument.", parameters="num1:field de type num\u00e9rique.\n")
    public static BigDecimal getValueOfMessageFieldNum(IMessageFieldNum num) {
        if (num != null) {
            return (BigDecimal)num.getValue();
        }
        return null;
    }

    @Description(description="Retourne la valeur date d'un Field de type Date pass\u00e9 en argument.", parameters="date1:field de type date.\n")
    public static Date getValueOfMessageFieldDate(IMessageFieldDate date) {
        if (date != null) {
            return (Date)date.getValue();
        }
        return null;
    }

    @Description(description="Renvoie une cha\u00eene dont la valeur est cette cha\u00eene, avec tous les espaces blancs en avant et en arri\u00e8re supprim\u00e9s.", parameters="alphanum1:cha\u00eene de caract\u00e8re \u00e0 modifier.\n")
    public static String trim(String value) {
        String timmedValue = null;
        if (value != null) {
            timmedValue = value.trim();
        }
        return timmedValue;
    }

    public static String trim(IMessageFieldAlphanum value) {
        return BuiltinFunctions.trim(BuiltinFunctions.getValueOfMessageFieldAlphanum(value));
    }

    @Description(description="Renvoie la repr\u00e9sentation en cha\u00eene de caract\u00e8re d'un BigDecimal, en utilisant la notation scientifique si un exposant est n\u00e9cessaire.", parameters="num1:le BigDecimal \u00e0 transformer en chaine de caract\u00e8re.\n")
    public static String numToString(BigDecimal x) {
        String bigDecimalAsString = null;
        if (x != null) {
            bigDecimalAsString = x.toString();
        }
        return bigDecimalAsString;
    }

    public static String numToString(IMessageFieldNum x) {
        return BuiltinFunctions.numToString(BuiltinFunctions.getValueOfMessageFieldNum(x));
    }

    @Description(description="Renvoie true si la date est null, false sinon.", parameters="date1:la date \u00e0 verifier.\n")
    public static Boolean nullDate(Date date) {
        if (date == null) {
            return true;
        }
        return false;
    }

    public static Boolean nullDate(IMessageFieldDate date) {
        return BuiltinFunctions.nullDate(BuiltinFunctions.getValueOfMessageFieldDate(date));
    }

    public static enum DateModification {
        DAY,
        MONTH,
        YEAR;

    }
}

