/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.presentation;

import fr.cnav.saturne.presentation.SaturneEditorPlugin;
import fr.cnav.saturne.presentation.SaturneModelWizard;
import fr.cnav.saturne.presentation.WizardNewSaturneModelCreationPage;
import fr.cnav.saturne.presentation.util.SaturneModelCreator;
import fr.cnav.saturne.presentation.util.SaturneModelWizardConfiguration;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class SaturneModelWizardSpec
extends SaturneModelWizard {
    private WizardNewSaturneModelCreationPage initialObjectCreationPage;

    @Override
    public boolean performFinish() {
        try {
            final IFile modelFile = this.getModelFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            SaturneModelCreator modelCreator = new SaturneModelCreator();
                            IContainer parent = modelFile.getParent();
                            String fileName = modelFile.getName();
                            String containerName = parent.getName();
                            String projectName = parent.getProject().getName();
                            SaturneModelWizardConfiguration configuration = new SaturneModelWizardConfiguration(projectName, containerName, fileName, SaturneModelWizardSpec.this.initialObjectCreationPage.getEncoding(), SaturneModelWizardSpec.this.initialObjectCreationPage.isFullValidModelToGenerate());
                            modelCreator.createSaturneModel(configuration);
                        }
                        catch (IOException e) {
                            SaturneEditorPlugin.INSTANCE.log(e);
                            progressMonitor.done();
                        }
                        catch (CoreException e) {
                            SaturneEditorPlugin.INSTANCE.log((Object)e);
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    @Override
                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            boolean result = true;
            try {
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
            }
            catch (PartInitException exception) {
                MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)SaturneEditorPlugin.INSTANCE.getString("_UI_OpenEditorError_label"), (String)exception.getMessage());
                result = false;
            }
            return result;
        }
        catch (InvocationTargetException e) {
            SaturneEditorPlugin.INSTANCE.log(e);
        }
        catch (InterruptedException e) {
            SaturneEditorPlugin.INSTANCE.log(e);
        }
        return false;
    }

    @Override
    public void addPages() {
        Object selectedElement;
        String dot = ".";
        this.newFileCreationPage = new SaturneModelWizard.SaturneModelWizardNewFileCreationPage("Whatever", this.selection);
        this.newFileCreationPage.setTitle(SaturneEditorPlugin.INSTANCE.getString("_UI_SaturneModelWizard_label"));
        this.newFileCreationPage.setDescription(SaturneEditorPlugin.INSTANCE.getString("_UI_SaturneModelWizard_description"));
        this.newFileCreationPage.setFileName(String.valueOf(SaturneEditorPlugin.INSTANCE.getString("_UI_SaturneEditorFilenameDefaultBase")) + dot + (String)FILE_EXTENSIONS.get(0));
        this.addPage((IWizardPage)this.newFileCreationPage);
        if (this.selection != null && !this.selection.isEmpty() && (selectedElement = this.selection.iterator().next()) instanceof IResource) {
            IResource selectedResource = (IResource)selectedElement;
            if (selectedResource.getType() == 1) {
                selectedResource = selectedResource.getParent();
            }
            if (selectedResource instanceof IFolder || selectedResource instanceof IProject) {
                this.newFileCreationPage.setContainerFullPath(selectedResource.getFullPath());
                String defaultModelBaseFilename = SaturneEditorPlugin.INSTANCE.getString("_UI_SaturneEditorFilenameDefaultBase");
                String defaultModelFilenameExtension = (String)FILE_EXTENSIONS.get(0);
                String modelFilename = String.valueOf(defaultModelBaseFilename) + dot + defaultModelFilenameExtension;
                int i = 1;
                while (((IContainer)selectedResource).findMember(modelFilename) != null) {
                    modelFilename = String.valueOf(defaultModelBaseFilename) + i + dot + defaultModelFilenameExtension;
                    ++i;
                }
                this.newFileCreationPage.setFileName(modelFilename);
            }
        }
        this.initialObjectCreationPage = new WizardNewSaturneModelCreationPage(SaturneEditorPlugin.INSTANCE.getString("_UI_SaturneModelWizard_label"), false);
        this.initialObjectCreationPage.setDescription(SaturneEditorPlugin.INSTANCE.getString("_UI_Wizard_initial_object_description"));
        this.addPage((IWizardPage)this.initialObjectCreationPage);
    }

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(SaturneEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(SaturneEditorPlugin.INSTANCE.getImage("full/wizban/NewSaturne")));
    }
}

