/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor;

import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.presentation.SaturneEditorPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Image;

public class MessageTreeKeyDecorator
extends BaseLabelProvider
implements ILabelDecorator {
    public Image decorateImage(Image image, Object element) {
        if (element instanceof MessageTreeObject && this.shouldBeDecorated((MessageTreeObject)element)) {
            return this.getDecorateImage(image);
        }
        return image;
    }

    private Image getDecorateImage(Image image) {
        if (image == null) {
            return ExtendedImageRegistry.INSTANCE.getImage(SaturneEditorPlugin.INSTANCE.getImage("full/ovr16/primary_key.gif"));
        }
        ArrayList<Object> images = new ArrayList<Object>(2);
        images.add(image);
        images.add(SaturneEditorPlugin.INSTANCE.getImage("full/ovr16/primary_key.gif"));
        DecoratedComposedImage composedImage = new DecoratedComposedImage(images);
        return ExtendedImageRegistry.INSTANCE.getImage((Object)composedImage);
    }

    private boolean shouldBeDecorated(MessageTreeObject messageTreeObject) {
        boolean result = false;
        if (messageTreeObject.getAdapter(Field.class) != null) {
            Field field = (Field)messageTreeObject.getAdapter(Field.class);
            if (field.isDeclarationKey()) {
                result = true;
            }
        } else if (messageTreeObject.getAdapter(FieldRefinement.class) != null) {
            Field field = ((FieldRefinement)messageTreeObject.getAdapter(FieldRefinement.class)).getField();
            if (field.isDeclarationKey()) {
                result = true;
            }
        } else if (messageTreeObject.getAdapter(Value.class) != null) {
            Value value = (Value)messageTreeObject.getAdapter(Value.class);
            Declaration decl = messageTreeObject.getDeclaration();
            Object parent = messageTreeObject.getParentMessageTreeObject().getParentElement();
            result = this.shouldBeDecorated(value, decl, parent);
        }
        return result;
    }

    private boolean shouldBeDecorated(Value value, Declaration decl, Object parent) {
        boolean result = false;
        if (decl != null && parent != null && decl.getKeyValues().get(parent) != null && !((EList)decl.getKeyValues().get(parent)).isEmpty() && ((EList)decl.getKeyValues().get(parent)).contains((Object)value)) {
            result = true;
        }
        return result;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    private static final class DecoratedComposedImage
    extends ComposedImage {
        private static final int OVERLAY = 7;

        private DecoratedComposedImage(Collection<?> images) {
            super(images);
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            ArrayList<ComposedImage.Point> result = new ArrayList<ComposedImage.Point>();
            result.add(new ComposedImage.Point());
            ComposedImage.Point overlay = new ComposedImage.Point();
            overlay.y = 7;
            result.add(overlay);
            return result;
        }
    }
}

