/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.providers;

import fr.cnav.autocontrole.helpers.AnomalyHelper;
import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.autocontrole.providers.detail.NormeDetailProvider;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;

public class AnomalieLabelProvider {
    private NormeDetailProvider normeDetailProvider = new NormeDetailProvider();

    public String getText(int index, Object element) {
        Object result = this.getValue(index, element);
        return result.toString();
    }

    public Object getValue(int index, Object element) {
        if (!(element instanceof Anomaly)) {
            return "";
        }
        Anomaly anomaly = (Anomaly)element;
        Object result = "";
        switch (index) {
            case 1: {
                Context anomalyContext = MessageFile.getInstance().getContext(anomaly);
                if (anomalyContext != null && MessageFile.getInstance().getMapContext2DeclarationRank() != null && MessageFile.getInstance().getMapContext2DeclarationRank().containsKey(anomalyContext)) {
                    result = String.valueOf(MessageFile.getInstance().getMapContext2DeclarationRank().get(anomalyContext));
                    break;
                }
                if (anomalyContext == null || String.valueOf(anomalyContext.getRank()) == null) break;
                result = String.valueOf(anomalyContext.getRank());
                break;
            }
            case 2: {
                result = MessageFile.getInstance().getAnomalies().indexOf(element) + 1;
                break;
            }
            case 0: {
                result = "";
                break;
            }
            case 3: {
                result = anomaly.getNumber();
                break;
            }
            case 4: {
                result = anomaly.getFieldLocalizer().getLineNumber();
                break;
            }
            case 5: {
                if (anomaly.getFieldId() == null) break;
                result = anomaly.getFieldId();
                break;
            }
            case 6: {
                if (anomaly.getFieldLabel() == null) break;
                result = anomaly.getFieldLabel();
                break;
            }
            case 7: {
                if (anomaly.getFieldValue() == null) break;
                result = anomaly.getFieldValue();
                break;
            }
            case 8: {
                if (anomaly.getCode() == null || anomaly.getMessage() == null) break;
                result = String.valueOf(anomaly.getCode()) + " / " + anomaly.getMessage();
                break;
            }
            case 9: {
                if (anomaly.getCode() == null) break;
                result = anomaly.getCode();
                break;
            }
            case 10: {
                if (anomaly.getMessage() == null) break;
                result = anomaly.getMessage();
                break;
            }
            case 100: {
                String nature = AnomalyHelper.getNature(anomaly, MessageFile.getInstance().getMapAnomalieContext(), MessageFile.getInstance().getMapContext2Declaration());
                if (nature == null) break;
                result = nature;
                break;
            }
            case 104: {
                if (anomaly.getCode() == null) break;
                result = anomaly.getCode();
                break;
            }
            case 105: {
                if (anomaly.getMessage() == null) break;
                result = anomaly.getMessage();
                break;
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public boolean isBloquant(Object element) {
        return element instanceof Anomaly && ((Anomaly)element).isBlocking();
    }

    public String getToolTip(Object element) {
        Object normeElt = MessageFile.getInstance().getNormeElt(element);
        DeclarationDescription eltDecl = null;
        if (element instanceof Anomaly) {
            eltDecl = AnomalyHelper.getDeclaration((Anomaly)element);
        }
        return this.normeDetailProvider.getText(normeElt, eltDecl);
    }
}

