/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.xml;

import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.ILoggingComponent;
import fr.cnav.saturne.validator.ITreeConsumer;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.impl.ITreeReader;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import fr.cnav.saturne.validator.xml.XMLHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLReader
implements ITreeReader,
ILoggingComponent {
    protected List<ITreeConsumer> consummers = new ArrayList<ITreeConsumer>();
    private IReportLogger logger;
    private OptionMap options;
    private StandardAccessor modelAccessor;
    private Map<String, String> qualifiedIdMap;
    private ControlMessages controlMessages;
    private final boolean saveBlock;
    private final boolean xmlNoPrefix;

    public XMLReader(IReportLogger theReportLogger, OptionMap theOptions, StandardAccessor modelAccessor, Map<String, String> qualifiedIdMap, ControlMessages messages, Boolean saveBlock, Boolean xmlNoPrefix) {
        this.logger = theReportLogger;
        this.options = theOptions;
        this.modelAccessor = modelAccessor;
        this.qualifiedIdMap = qualifiedIdMap;
        this.controlMessages = messages;
        this.saveBlock = saveBlock;
        this.xmlNoPrefix = xmlNoPrefix;
    }

    @Override
    public void addConsumer(ITreeConsumer consumer) {
        if (!this.consummers.contains(consumer)) {
            this.consummers.add(consumer);
        }
    }

    @Override
    public void read(InputStream input) throws IOException, TreeProcessingException {
        XMLHandler handler = new XMLHandler(this.modelAccessor, this.qualifiedIdMap, this.logger, this.controlMessages, this.saveBlock, this.xmlNoPrefix);
        handler.addConsumer(this.consummers);
        try {
            SAXParserFactory parserfactory = SAXParserFactory.newInstance();
            parserfactory.setNamespaceAware(true);
            SAXParser parser = parserfactory.newSAXParser();
            parser.parse(input, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            throw new TreeProcessingException(e);
        }
        catch (SAXException e) {
            if (e.getCause() instanceof TreeProcessingException) {
                throw (TreeProcessingException)e.getCause();
            }
            if (e.getCause() instanceof TooManyAnomaliesException) {
                throw new TreeProcessingException(e.getCause());
            }
            throw new TreeProcessingException(e);
        }
    }

    @Override
    public OptionMap getOptions() {
        return this.options;
    }

    @Override
    public IReportLogger getReportLogger() {
        return this.logger;
    }
}

