/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report.impl;

import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.validator.report.impl.AnomalyBuckets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DsnAnomalyBuckets
extends AnomalyBuckets {
    private static final String EMPLOYEE_FULL_QUALIFIED_ID = "S21.G00.30";
    private static final String DECLARATION_FULL_QUALIFIED_ID = "S20.G00.05";
    private static final String CONTRACT_FULL_QUALIFIED_ID = "S21.G00.40";
    private static final Logger LOGGER = LoggerFactory.getLogger(DsnAnomalyBuckets.class);
    private Context lastDeclarationContext;

    public DsnAnomalyBuckets(int threshold) {
        super(threshold);
    }

    @Override
    protected AnomalyBuckets.AnomalyInfo getInfo(Anomaly anomaly, int contextRank, Context context) {
        StringBuilder builder = new StringBuilder();
        if (EMPLOYEE_FULL_QUALIFIED_ID.equals(context.getblockQualifiedId())) {
            if (this.lastDeclarationContext == null) {
                LOGGER.error("The parent context of the employee context \"" + context.getblockQualifiedId() + "\" cannot be null.");
                builder.append(anomaly.getCode()).append('/').append(anomaly.getFieldId()).append(contextRank).append('/').append(context.getblockQualifiedId());
            } else {
                builder.append(anomaly.getCode()).append('/').append(anomaly.getFieldId()).append('/').append(this.lastDeclarationContext.getRank()).append('/').append(this.lastDeclarationContext.getblockQualifiedId());
            }
        } else if (CONTRACT_FULL_QUALIFIED_ID.equals(context.getblockQualifiedId())) {
            if (this.lastDeclarationContext == null) {
                LOGGER.error("The declaration parent context of the contract context \"" + context.getblockQualifiedId() + "\" cannot be null.");
                builder.append(anomaly.getCode()).append('/').append(anomaly.getFieldId()).append(contextRank).append('/').append(context.getblockQualifiedId());
            } else {
                builder.append(anomaly.getCode()).append('/').append(anomaly.getFieldId()).append('/').append(this.lastDeclarationContext.getRank()).append('/').append(this.lastDeclarationContext.getblockQualifiedId());
            }
        } else {
            builder.append(anomaly.getCode()).append('/').append(anomaly.getFieldId()).append(contextRank).append('/').append(context.getblockQualifiedId());
        }
        String key = builder.toString();
        AnomalyBuckets.AnomalyInfo result = (AnomalyBuckets.AnomalyInfo)this.anomalyInfos.get(key);
        if (result == null) {
            result = new AnomalyBuckets.AnomalyInfo(anomaly);
            this.anomalyInfos.put(key, result);
        }
        return result;
    }

    @Override
    public boolean mustLogAnomaly(Anomaly anomaly, Context context, int declarationRank) {
        boolean keepLogging;
        AnomalyBuckets.AnomalyInfo info = this.getInfo(anomaly, declarationRank, context);
        boolean bl = keepLogging = info.count < this.threshold;
        if (!keepLogging) {
            info.lastAnomaly.incrementAnomalyNumber();
        } else {
            info.lastAnomaly = anomaly;
            ++info.count;
        }
        return keepLogging;
    }

    @Override
    public void enterContext(Context context) {
        if (DECLARATION_FULL_QUALIFIED_ID.equals(context.getblockQualifiedId())) {
            this.lastDeclarationContext = context;
        }
    }
}

