/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.csv;

import com.opencsv.CSVWriter;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.validator.ITreeAndDeclarationConsumer;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.impl.ValidatorEncodingHandler;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;

public class CSVSerializer
implements ITreeAndDeclarationConsumer {
    protected final CSVWriter csvWriter;
    private final Writer writer;
    private final String encoding;
    private final ByteArrayOutputStream csvOutputStream = new ByteArrayOutputStream();

    public CSVSerializer(Standard theStandard, OutputStream outputStream, String encoding, char theDelimiter, char theSeparator) throws ConversionSerializationException {
        char delimiter = theDelimiter;
        char separator = theSeparator;
        if (theStandard == null) {
            throw new IllegalArgumentException("The standard should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNamespacePrefix() == null) {
            throw new IllegalArgumentException("The standard namespace prefix should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNameSpace() == null) {
            throw new IllegalArgumentException("The standard namespace should not be null. The serialization will not be realized.");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The encoding should not be null. The serialization will not be realized.");
        }
        if (delimiter == '\u0000') {
            delimiter = '\"';
        }
        if (separator == '\u0000') {
            separator = ';';
        }
        ValidatorEncodingHandler validatorEncodingHandler = new ValidatorEncodingHandler();
        if (outputStream == null) {
            throw new IllegalArgumentException("The output stream should not be null. The serialization will not be realized.");
        }
        Charset charset = validatorEncodingHandler.getEncodingToUse(encoding, theStandard);
        this.writer = new OutputStreamWriter(outputStream, charset);
        this.csvWriter = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)this.csvOutputStream, charset), separator, delimiter, '\\');
        this.encoding = charset.toString();
    }

    public CSVSerializer(Standard theStandard, Writer parent, String encoding) throws ConversionSerializationException {
        if (theStandard == null) {
            throw new IllegalArgumentException("The standard should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNamespacePrefix() == null) {
            throw new IllegalArgumentException("The standard namespace prefix should not be null. The serialization will not be realized.");
        }
        if (theStandard.getNameSpace() == null) {
            throw new IllegalArgumentException("The standard namespace should not be null. The serialization will not be realized.");
        }
        if (encoding == null) {
            throw new IllegalArgumentException("The encoding should not be null. The serialization will not be realized.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("The writer should not be null. The serialization will not be realized.");
        }
        ValidatorEncodingHandler validatorEncodingHandler = new ValidatorEncodingHandler();
        Charset charset = validatorEncodingHandler.getEncodingToUse(encoding, theStandard);
        this.writer = parent;
        this.csvWriter = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)this.csvOutputStream, charset), ';', '\"', '\\');
        this.encoding = charset.toString();
    }

    @Override
    public void startTree() throws TreeProcessingException {
        this.csvWriter.writeNext(new String[]{this.encoding});
    }

    @Override
    public void endTree() throws TreeProcessingException {
        try {
            this.csvWriter.flush();
            this.writer.write(this.csvOutputStream.toString(this.encoding));
            this.csvWriter.close();
            this.writer.flush();
        }
        catch (IOException exception) {
            throw new TreeProcessingException("An exception has occured while appending the footer of the converted file: " + exception.getMessage(), exception);
        }
    }

    @Override
    public void enterBlock(IMessageBlock block) throws TreeProcessingException {
        if (block.getStandardBlockDescription() instanceof BlockDescription) {
            List fields = ((BlockDescription)block.getStandardBlockDescription()).getFields();
            String[] line = new String[fields.size() + 1];
            line[0] = block.getStandardBlockDescription().getFullQualifiedId();
            int i = 0;
            while (i < fields.size()) {
                IMessageField<?> msgField = block.getField(i);
                if (msgField != null) {
                    line[i + 1] = msgField.getOriginalValueAsString();
                }
                ++i;
            }
            this.csvWriter.writeNext(line);
        }
    }

    @Override
    public void exitBlock(IMessageBlock block) throws TreeProcessingException {
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void signalDeclaration(IMessageBlock block, DeclarationDescription declaration) throws TreeProcessingException {
    }
}

