/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.metacontrol;

import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.Rule;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.metacontrol.AbstractMetacontrolValidation;
import fr.cnav.saturne.dsl.metacontrol.CanonicalNormalizer;
import fr.cnav.saturne.dsl.metacontrol.MetacontrolContradictoryValidation;
import fr.cnav.saturne.dsl.metacontrol.MetacontrolValidationInfo;
import fr.cnav.saturne.dsl.metacontrol.TransformationException;
import fr.cnav.saturne.dsl.parser.FormuleTraducteur;
import fr.cnav.saturne.dsl.parser.FormuleTraducteurException;
import fr.cnav.saturne.dsl.parser.ParserConfigurationException;
import fr.cnav.saturne.dsl.parser.configuration.StandardParserConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MetacontrolValidation
extends AbstractMetacontrolValidation {
    private static final String AND = " et ";
    private List<MetacontrolValidationInfo> validationInfos = new ArrayList<MetacontrolValidationInfo>();
    private Map<Expression, GenericRule> clauseToRuleMap = new HashMap<Expression, GenericRule>();
    private ModelAccessor modelAccessor;
    private Standard standard;
    private ArrayList<Expression> clauses;

    public MetacontrolValidation(Standard theStandard) throws IOException {
        this.standard = theStandard;
        this.modelAccessor = new ModelAccessor(this.standard);
    }

    public List<MetacontrolValidationInfo> validateMetacontrole(IProgressMonitor monitor) throws ParserConfigurationException, FormuleTraducteurException, TransformationException {
        this.clauses = new ArrayList();
        FormuleTraducteur parser = new FormuleTraducteur(new StandardParserConfiguration(this.standard, null));
        monitor.subTask("Conjunctive Normal Form transformation of rules expression");
        for (GenericRule genericRule : this.standard.getRules().getRules()) {
            Rule rule;
            String dslExpression;
            if (!(genericRule instanceof Rule) || (dslExpression = (rule = (Rule)genericRule).getDslExpression()) == null || dslExpression.length() <= 0 || rule.getSubject() == null || rule.getComputedContext() == null) continue;
            Expression exp = parser.processDSL(dslExpression, rule.getSubject().getFullQualifiedId(), rule.getComputedContext().getFullQualifiedId());
            Expression cnfExpression = new CanonicalNormalizer().transform(exp, this.standard);
            this.initClausesList(rule, exp, cnfExpression);
        }
        monitor.worked(1);
        monitor.subTask("Check redundance clauses");
        this.checkRedundancy();
        monitor.worked(1);
        monitor.subTask("Check dependance clauses");
        this.checkDependence();
        monitor.worked(1);
        monitor.subTask("Check contradictory clauses");
        MetacontrolContradictoryValidation contradictoryValidation = new MetacontrolContradictoryValidation(this.clauses, this.modelAccessor, this.clauseToRuleMap);
        this.validationInfos.addAll(contradictoryValidation.checkContradictions());
        monitor.worked(1);
        return this.validationInfos;
    }

    private void initClausesList(Rule rule, Expression exp, Expression cnfExpression) {
        boolean expressionAlwaysTrue;
        boolean bl = expressionAlwaysTrue = cnfExpression instanceof Nary && ((Nary)cnfExpression).getOperands().size() == 0;
        if (!expressionAlwaysTrue) {
            ArrayList<Expression> clausesFromCnfExpression = this.getClausesFromCnfExpression(cnfExpression);
            this.clauses.addAll(clausesFromCnfExpression);
            for (Expression clause : clausesFromCnfExpression) {
                this.clauseToRuleMap.put(clause, rule);
            }
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("Le contr\u00f4le ").append(rule.getFullId()).append(" affiche une expression toujours vrai. Il n'est donc pas pertinent.");
            this.validationInfos.add(MetacontrolValidationInfo.warning(sb.toString(), new ArrayList<String>(Arrays.asList(rule.getFullId())), new ArrayList<String>(Arrays.asList(this.getStringExpression(exp)))));
        }
    }

    private void checkRedundancy() {
        ArrayList<Expression> clausesToRemove = new ArrayList<Expression>();
        int size = this.clauses.size();
        int i = 0;
        while (i < size) {
            Expression clause1 = this.clauses.get(i);
            int j = i + 1;
            while (j < size) {
                Expression clause2 = this.clauses.get(j);
                if (this.areClausesDuplicate(clause1, clause2)) {
                    String rule1 = this.clauseToRuleMap.get(clause1).getFullId();
                    String rule2 = this.clauseToRuleMap.get(clause2).getFullId();
                    StringBuilder sb = new StringBuilder();
                    sb.append("Les contr\u00f4les ").append(rule1).append(AND).append(rule2);
                    sb.append(" induisent une redondance. ");
                    if (EcoreUtil.equals((EObject)clause1, (EObject)clause2)) {
                        sb.append("La clause redondante est ");
                        sb.append(this.getStringExpression(clause1));
                    } else {
                        sb.append("Les clauses redondantes sont ");
                        sb.append(this.getStringExpression(clause1)).append(AND).append(this.getStringExpression(clause2));
                    }
                    this.validationInfos.add(MetacontrolValidationInfo.warning(sb.toString(), new ArrayList<String>(Arrays.asList(rule1, rule2)), new ArrayList<String>(Arrays.asList(this.getStringExpression(clause1), this.getStringExpression(clause2)))));
                    clausesToRemove.add(clause2);
                }
                ++j;
            }
            ++i;
        }
        this.clauses.removeAll(clausesToRemove);
    }

    private void checkDependence() {
        int size = this.clauses.size();
        int i = 0;
        while (i < size) {
            Expression clause = this.clauses.get(i);
            int j = 0;
            while (j < size) {
                Expression clause2;
                if (i != j && this.isClauseDependent(clause, clause2 = this.clauses.get(j))) {
                    this.logDependenceInfo(clause, clause2);
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean isClauseDependent(Expression clause1, Expression clause2) {
        ArrayList<Expression> literalsFromClause2;
        int nbLiteralInClause2;
        boolean isClauseDependent = false;
        ArrayList<Expression> literalsFromClause1 = this.getLiteralsFromClause(clause1);
        int nbLiteralInClause1 = literalsFromClause1.size();
        if (nbLiteralInClause1 <= (nbLiteralInClause2 = (literalsFromClause2 = this.getLiteralsFromClause(clause2)).size())) {
            for (Expression literal : literalsFromClause1) {
                boolean isLiteralPresent = false;
                int nbLiteral = 0;
                while (!isLiteralPresent && nbLiteral < nbLiteralInClause2) {
                    if (EcoreUtil.equals((EObject)literal, (EObject)literalsFromClause2.get(nbLiteral))) {
                        isLiteralPresent = true;
                    }
                    ++nbLiteral;
                }
                if (isLiteralPresent) continue;
                return false;
            }
            isClauseDependent = true;
        }
        return isClauseDependent;
    }

    private void logDependenceInfo(Expression clause, Expression clause2) {
        String rule1 = this.clauseToRuleMap.get(clause).getFullId();
        String rule2 = this.clauseToRuleMap.get(clause2).getFullId();
        StringBuilder sb = new StringBuilder();
        sb.append("Les contr\u00f4les ").append(rule1).append(AND).append(rule2);
        sb.append(" induisent une dependance. La clause ");
        sb.append(this.getStringExpression(clause)).append(" implique la clause ").append(this.getStringExpression(clause2));
        this.validationInfos.add(MetacontrolValidationInfo.warning(sb.toString(), new ArrayList<String>(Arrays.asList(rule1, rule2)), new ArrayList<String>(Arrays.asList(this.getStringExpression(clause), this.getStringExpression(clause2)))));
    }
}

