/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.views;

import fr.cnav.autocontrol.export.Activator;
import fr.cnav.autocontrole.exception.ExceptionKind;
import fr.cnav.autocontrole.helpers.MessageHelper;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.providers.detail.NormeDetailProvider;
import fr.cnav.autocontrole.ui.Messages;
import fr.cnav.autocontrole.ui.views.HelperScroll;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.editor.MessageTreeKeyDecorator;
import fr.cnav.saturne.editor.MessageTreeLabelProvider;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.editor.MessageTreeRefinementDecorator;
import fr.cnav.saturne.editor.autoctrl.MessageTreeContentProvider;
import fr.cnav.saturne.editor.autoctrl.MessageTreeObjectComparer;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.part.ViewPart;

public class NormeView
extends ViewPart {
    public static final String ID = "fr.cnav.autocontrole.ui.views.NormeView";
    private Text textDetail;
    private TreeViewer treeViewer;
    private Group grpDetail;
    private NormeDetailProvider normeDetailProvider = new NormeDetailProvider();
    private Composite parent;
    private ComposedAdapterFactory adapterFactory;

    public void createPartControl(Composite parent) {
        try {
            this.parent = parent;
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, false));
            SashForm sashForm = new SashForm(container, 2560);
            sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.initGroupRubrique((Composite)sashForm);
            this.initGroupDetail((Composite)sashForm);
            sashForm.setWeights(new int[]{323, 134});
            this.createActions();
            this.initializeToolBar();
            this.initializeMenu();
            this.initializeData();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_NORME_VIEW_INITIALIZATION.getMessage(), t));
        }
    }

    private void initGroupDetail(Composite sashForm) {
        this.grpDetail = new Group(sashForm, 0);
        this.grpDetail.setLayout((Layout)new GridLayout(1, false));
        this.grpDetail.setText(Messages.NormeView_1);
        this.textDetail = new Text((Composite)this.grpDetail, 2818);
        GridData gd_textDetail = new GridData(4, 4, true, true, 1, 1);
        gd_textDetail.minimumHeight = 80;
        gd_textDetail.heightHint = 80;
        this.textDetail.setLayoutData((Object)gd_textDetail);
        this.textDetail.setEditable(false);
        this.textDetail.setBounds(0, 0, 76, 21);
        Font font = new Font((Device)sashForm.getDisplay(), "Courier New", 10, 0);
        this.textDetail.setFont(font);
    }

    private void initGroupRubrique(Composite sashForm) {
        Group grpSousgroupesEtRubriques = new Group(sashForm, 0);
        grpSousgroupesEtRubriques.setLayout((Layout)new GridLayout(1, false));
        grpSousgroupesEtRubriques.setText(Messages.NormeView_0);
        PatternFilter filter = new PatternFilter();
        FilteredTree tree = new FilteredTree((Composite)grpSousgroupesEtRubriques, 2820, filter, true);
        this.treeViewer = tree.getViewer();
        tree.setLayoutData((Object)new GridData(1808));
    }

    public void initializeData() {
        try {
            this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            SaturneItemProviderAdapterFactory saturneFactory = new SaturneItemProviderAdapterFactory();
            this.adapterFactory.addAdapterFactory((AdapterFactory)saturneFactory);
            this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
            this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
            this.treeViewer.setContentProvider((IContentProvider)new MessageTreeContentProvider((AdapterFactory)this.adapterFactory, saturneFactory));
            DecoratingColumLabelProvider decoratingColumLabelProvider1 = new DecoratingColumLabelProvider((ILabelProvider)new MessageTreeLabelProvider((AdapterFactory)this.adapterFactory), (ILabelDecorator)new MessageTreeKeyDecorator());
            DecoratingColumLabelProvider decoratingColumLabelProvider2 = new DecoratingColumLabelProvider((ILabelProvider)decoratingColumLabelProvider1, (ILabelDecorator)new MessageTreeRefinementDecorator());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)decoratingColumLabelProvider2);
            this.treeViewer.setComparer((IElementComparer)new MessageTreeObjectComparer());
            this.treeViewer.setInput((Object)new MessageTreeObject(MessageHelper.getStandardMessage(), null));
        }
        catch (Throwable t) {
            t.printStackTrace();
            Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_NORME_VIEW_REFRESH.getMessage(), t));
            MessageDialog.openError((Shell)this.parent.getShell(), (String)Messages.OpenViewNormeHandler_0, (String)String.format(ExceptionKind.ERROR_NORME_VIEW_REFRESH.getMessage(), new Object[0]));
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
            }
            catch (PartInitException e) {
                e.printStackTrace();
                Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_OPENING_ERROR_LOG.getMessage(), (Throwable)e));
            }
        }
    }

    private void createActions() {
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    if (event.getSelection() instanceof StructuredSelection && ((StructuredSelection)event.getSelection()).getFirstElement() != null) {
                        Object selectedObject = ((StructuredSelection)event.getSelection()).getFirstElement();
                        Object element = ((MessageTreeObject)selectedObject).getElement();
                        BlockDescription elementDescription = null;
                        StandardAccessor standardAccessor = StandardHelper.getInstance().getStandardAccessor();
                        if (element instanceof Block) {
                            elementDescription = standardAccessor.getBlockDescription(((Block)element).getFullQualifiedId());
                        } else if (element instanceof BlockRefinement) {
                            elementDescription = standardAccessor.getBlockDescription(((BlockRefinement)element).getBlock().getFullQualifiedId());
                        } else if (element instanceof Field) {
                            elementDescription = standardAccessor.getFieldDescription(((Field)element).getFullQualifiedId());
                        } else if (element instanceof FieldRefinement) {
                            elementDescription = standardAccessor.getFieldDescription(((FieldRefinement)element).getField().getFullQualifiedId());
                        }
                        Declaration decl = ((MessageTreeObject)selectedObject).getDeclaration();
                        DeclarationDescription declarationDescription = null;
                        if (decl != null) {
                            for (DeclarationDescription declDescription : standardAccessor.getStandardDescription().getDeclarations()) {
                                if (declDescription.getName() == null || !declDescription.getName().equals(decl.getName())) continue;
                                declarationDescription = declDescription;
                            }
                        }
                        NormeView.this.textDetail.setText(NormeView.this.normeDetailProvider.getText((Object)elementDescription, declarationDescription));
                        NormeView.this.updateScroll();
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_NORME_VIEW_REFRESH.getMessage(), t));
                    MessageDialog.openError((Shell)NormeView.this.parent.getShell(), (String)Messages.OpenViewNormeHandler_0, (String)String.format(ExceptionKind.ERROR_NORME_VIEW_REFRESH.getMessage(), new Object[0]));
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                        Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_OPENING_ERROR_LOG.getMessage(), (Throwable)e));
                    }
                }
            }
        });
        this.textDetail.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                NormeView.this.updateScroll();
            }
        });
    }

    private void updateScroll() {
        HelperScroll.updateScolls(this.textDetail);
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
        this.parent.setFocus();
        this.treeViewer.getControl().setFocus();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }
}

