/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.views;

import fr.cnav.autocontrol.export.ReportExportType;
import fr.cnav.autocontrole.INormSerializerFactory;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.autocontrole.ui.AutocontrolUiPlugin;
import fr.cnav.autocontrole.ui.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExportWizardPage
extends WizardPage {
    private static final String START = "*";
    private static final String POINT = ".";
    private static final String DEFAULT_CONTENT_TYPE = "application/XML";
    private Text textFile;
    private Combo comboExport;
    private Map<Integer, String> labelIndexToContentType;
    private List<String> serializerLabelList;
    private List<String> handledExtension;

    public ExportWizardPage() {
        super("wizardPage");
        this.setTitle(Messages.ExportWizardPage_5);
        this.setDescription(Messages.ExportWizardPage_6);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblFichier = new Label(container, 0);
        lblFichier.setText(Messages.ExportWizardPage_7);
        Composite compositeFile = new Composite(container, 0);
        compositeFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        compositeFile.setLayout((Layout)new GridLayout(2, false));
        this.textFile = new Text(compositeFile, 2048);
        this.textFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowse = new Button(compositeFile, 0);
        btnBrowse.setText(Messages.ExportWizardPage_8);
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportWizardPage.this.handleBrowseButtonPressed();
            }
        });
        Label lblFormat = new Label(container, 0);
        lblFormat.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFormat.setText(Messages.ExportWizardPage_9);
        INormSerializerFactory serializerFactory = StandardHelper.getInstance().getSerializerFactory();
        this.comboExport = new Combo(container, 0);
        this.labelIndexToContentType = new HashMap<Integer, String>();
        this.serializerLabelList = new ArrayList<String>();
        this.handledExtension = new ArrayList<String>();
        Set handledContentTypes = serializerFactory.getHandledContentTypes();
        int labelIndex = 0;
        for (String handledContentType : handledContentTypes) {
            this.labelIndexToContentType.put(labelIndex, handledContentType);
            this.serializerLabelList.add(serializerFactory.getSerializerLabel(handledContentType));
            this.handledExtension.add(serializerFactory.getSerializerExtension(handledContentType));
            ++labelIndex;
        }
        String defaultContentType = serializerFactory.getDefaultContentType();
        if (defaultContentType == null || "".equals(defaultContentType)) {
            defaultContentType = DEFAULT_CONTENT_TYPE;
        }
        if (this.serializerLabelList.size() == 0) {
            this.comboExport.setText(Messages.ExportWizardPage_19);
        } else {
            this.comboExport.add(defaultContentType);
            this.comboExport.setItems(this.serializerLabelList.toArray(new String[0]));
            this.comboExport.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.comboExport.select(this.serializerLabelList.indexOf(serializerFactory.getSerializerLabel(defaultContentType)));
            this.comboExport.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.widget instanceof Combo) {
                        ExportWizardPage.this.updateFileExtension((String)ExportWizardPage.this.handledExtension.get(((Combo)e.widget).getSelectionIndex()));
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.initFile();
        this.validateFileText();
    }

    protected void updateFileExtension(String extension) {
        if (!this.textFile.getText().endsWith(extension)) {
            Path path = new Path(this.textFile.getText());
            path = path.removeFileExtension();
            path = path.addFileExtension(this.comboExport.getText().toLowerCase());
            this.textFile.setText(path.toOSString());
            this.validateFileText();
        }
    }

    protected void handleBrowseButtonPressed() {
        String selectedFileName;
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        dialog.setFilterExtensions(this.getFilterExtList());
        dialog.setFilterIndex(this.getDefaultFilterIndex());
        dialog.setText(Messages.ExportWizardPage_10);
        String currentSourceString = this.textFile.getText();
        File file = new File(this.textFile.getText());
        if (file.isFile()) {
            int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
            if (lastSeparatorIndex != -1) {
                dialog.setFileName(currentSourceString.substring(lastSeparatorIndex + 1, currentSourceString.length()));
            }
        } else {
            dialog.setFileName(currentSourceString);
        }
        if ((selectedFileName = dialog.open()) != null) {
            this.textFile.setText(selectedFileName);
            this.updateComboFormat();
        }
        this.validateFileText();
    }

    private String[] getFilterExtList() {
        String[] result = new String[this.handledExtension.size()];
        int i = 0;
        for (String contentType : this.handledExtension) {
            result[i] = "*." + contentType;
            ++i;
        }
        return result;
    }

    private int getDefaultFilterIndex() {
        Path path = new Path(this.textFile.getText());
        if (!"".equals(path.getFileExtension())) {
            for (String contentType : this.handledExtension) {
                if (!path.getFileExtension().equalsIgnoreCase(contentType)) continue;
                return this.handledExtension.indexOf(contentType);
            }
        }
        return 0;
    }

    private void updateComboFormat() {
        Path path = new Path(this.textFile.getText());
        if (!"".equals(path.getFileExtension())) {
            for (String contentType : this.handledExtension) {
                if (!path.getFileExtension().equalsIgnoreCase(contentType)) continue;
                this.comboExport.select(this.handledExtension.indexOf(contentType));
            }
        }
    }

    private boolean exists(String extension) {
        for (String contentType : this.handledExtension) {
            if (!extension.equalsIgnoreCase(contentType)) continue;
            return true;
        }
        return false;
    }

    private void initFile() {
        String folder = AutocontrolUiPlugin.getDefault().getPreferenceStore().getString("VALIDATION_FOLDER");
        String absolutePath = MessageFile.getInstance().getInputFile().getAbsolutePath();
        Path folderPath = new Path(folder);
        Path filePath = new Path(absolutePath);
        if (this.isExistingFolder((IPath)folderPath) || folderPath.getFileExtension() == null) {
            String extension = ReportExportType.getDefault().getExtension();
            filePath = filePath.addFileExtension(extension);
        }
        this.textFile.setText(filePath.toFile().getPath());
        this.textFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportWizardPage.this.validateFileText();
            }
        });
        this.textFile.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                Path path = new Path(ExportWizardPage.this.textFile.getText());
                if (path.getFileExtension() == null) {
                    path = path.addFileExtension(ExportWizardPage.this.comboExport.getText().toLowerCase());
                    ExportWizardPage.this.textFile.setText(path.toOSString());
                } else if (!path.getFileExtension().equals(ExportWizardPage.this.comboExport.getText().toLowerCase())) {
                    ExportWizardPage.this.updateComboFormat();
                }
                ExportWizardPage.this.validateFileText();
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private boolean isExistingFolder(IPath path) {
        boolean isExistingFolder = false;
        File file = new File(path.toOSString());
        if (file.exists() && file.isDirectory()) {
            isExistingFolder = true;
        }
        return isExistingFolder;
    }

    protected void validateFileText() {
        if (this.serializerLabelList.size() > 0) {
            if (this.textFile.getText().equals("")) {
                this.setErrorMessage(Messages.ExportWizardPage_14);
                this.setPageComplete(false);
            } else {
                Path path;
                File file = new File(this.textFile.getText());
                File directory = file.getParentFile();
                if (file.exists()) {
                    if (!file.canWrite()) {
                        this.setErrorMessage(Messages.ExportWizardPage_15);
                        this.setPageComplete(false);
                        return;
                    }
                } else {
                    if (directory != null && !directory.exists()) {
                        this.setErrorMessage(Messages.ExportWizardPage_16);
                        this.setPageComplete(false);
                        return;
                    }
                    if (directory != null && !directory.canWrite()) {
                        this.setErrorMessage(Messages.ExportWizardPage_16);
                        this.setPageComplete(false);
                        return;
                    }
                }
                if (!this.exists((path = new Path(file.getAbsolutePath())).getFileExtension())) {
                    this.setErrorMessage(Messages.ExportWizardPage_17);
                    this.setPageComplete(false);
                    return;
                }
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        }
    }

    public String getFile() {
        if (this.textFile != null) {
            return this.textFile.getText();
        }
        return "";
    }

    public String getContentType() {
        if (this.comboExport != null) {
            Integer serialiserLabelSelected = this.comboExport.getSelectionIndex();
            return this.labelIndexToContentType.get(serialiserLabelSelected);
        }
        return "";
    }
}

