/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.handlers;

import fr.cnav.autocontrole.ui.AutocontrolUiPlugin;
import fr.cnav.autocontrole.ui.Messages;
import fr.cnav.autocontrole.ui.dialogs.ProgressMonitorWithTitle;
import fr.cnav.autocontrole.update.ProvisonningProductService;
import fr.cnav.autocontrole.update.UpdateException;
import fr.cnav.autocontrole.update.UpdateValService;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

public class UpdateHandler
extends AbstractHandler {
    private boolean updateAvailable;
    volatile IStatus checkUpdateStatus;
    private boolean showUpdateOkMessage = true;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        final UpdateValService updateService = new UpdateValService(System.getProperty("fr.cnav.autocontrole.updatesite.loc"));
        final ProvisonningProductService provisonningProductValService = new ProvisonningProductService(System.getProperty("fr.cnav.autocontrole.updatesite.loc"));
        final Shell parent = Display.getDefault().getActiveShell();
        ProgressMonitorWithTitle checkForUpdateDialog = new ProgressMonitorWithTitle(parent, Messages.UpdateHandler_1);
        this.updateAvailable = false;
        try {
            checkForUpdateDialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        progressMonitor.setTaskName(Messages.UpdateHandler_2);
                        provisonningProductValService.isUpdateSite();
                        UpdateHandler.this.updateAvailable = updateService.checkForUpdate(progressMonitor);
                        UpdateHandler.this.checkUpdateStatus = Status.OK_STATUS;
                        progressMonitor.setTaskName(String.valueOf(Messages.UpdateHandler_2) + Status.OK_STATUS);
                    }
                    catch (UpdateException e) {
                        UpdateHandler.this.checkUpdateStatus = new Status(4, "fr.cnav.autocontrole.ui", Messages.UpdateFailureMessage_0, (Throwable)e);
                        AutocontrolUiPlugin.getDefault().getLog().log(UpdateHandler.this.checkUpdateStatus);
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            Status result = new Status(4, "fr.cnav.autocontrole.ui", String.valueOf(Messages.UpdateFailureMessage_0) + e.getMessage(), (Throwable)e);
            AutocontrolUiPlugin.getDefault().getLog().log((IStatus)result);
            StatusManager.getManager().handle((IStatus)result, 2);
        }
        if (this.updateAvailable) {
            if (MessageDialog.openConfirm((Shell)parent, (String)Messages.UpdateConfirmationTitle_0, (String)Messages.UpdateConfirmationQuestion_0)) {
                ProgressMonitorWithTitle doUpdateDialog = new ProgressMonitorWithTitle(parent, Messages.UpdateHandler_1);
                try {
                    doUpdateDialog.run(true, false, new IRunnableWithProgress(){

                        public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                            try {
                                progressMonitor.setTaskName(String.valueOf(Messages.UpdateHandler_1) + "..." + Status.OK_STATUS);
                                updateService.update(progressMonitor);
                                Display.getDefault().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        MessageDialog.openInformation((Shell)parent, (String)Messages.UpdateConfirmationTitle_0, (String)Messages.UpdateHandler_0);
                                        PlatformUI.getWorkbench().restart();
                                    }
                                });
                            }
                            catch (UpdateException e) {
                                Status result = new Status(4, "fr.cnav.autocontrole.ui", Messages.UpdateFailureMessage_0, (Throwable)e);
                                AutocontrolUiPlugin.getDefault().getLog().log((IStatus)result);
                                StatusManager.getManager().handle((IStatus)result, 3);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    Status result = new Status(4, "fr.cnav.autocontrole.ui", String.valueOf(Messages.UpdateFailureMessage_0) + e.getMessage(), (Throwable)e);
                    AutocontrolUiPlugin.getDefault().getLog().log((IStatus)result);
                    StatusManager.getManager().handle((IStatus)result, 3);
                }
                catch (InterruptedException e) {
                    Status result = new Status(4, "fr.cnav.autocontrole.ui", String.valueOf(Messages.UpdateFailureMessage_0) + e.getMessage(), (Throwable)e);
                    AutocontrolUiPlugin.getDefault().getLog().log((IStatus)result);
                    StatusManager.getManager().handle((IStatus)result, 3);
                }
            }
        } else if (this.checkUpdateStatus.isOK()) {
            if (this.showUpdateOkMessage) {
                MessageDialog.openInformation((Shell)parent, (String)Messages.UpdateConfirmationTitle_0, (String)Messages.NoUpdateAvailable_0);
            }
        } else {
            StatusManager.getManager().handle(this.checkUpdateStatus, 2);
        }
        return null;
    }

    public void setShowUpdateOkMessage(boolean showUpdateOkMessage) {
        this.showUpdateOkMessage = showUpdateOkMessage;
    }
}

