grammar Formules;

options {
//  backtrack=true;
//  memoize=true;
  language = Java;
}
@header {
/*******************************************************************************
* Logiciel créé en 2009 par la Caisse Nationale d'Assurance Vieillesse (Cnav) France.
* Logiciel protégé au sens de l'article L.112-2 13 du Code de la propriété intellectuelle (CPI).
* Tous les droits relatifs audit logiciel, sa documentation,
* y compris le matériel de conception préparatoire sont la propriété de la Cnav au sens du CPI.
* Ce fichier appartient a la suite d'outils SATURNE
* (Suite Applicative pour des Traitements Unifiés et Rationalisés fondés sur une Norme d'Echange).
* depot INPI en cours
*
* Ce logiciel et sa documentation sont proteges par la licence incluse.
* Vous devez avoir souscrit à une licence concedee par la Cnav
* pour installer et utiliser ce logiciel.
*
*
* This file is part of the SATURNE Tool Suite
* (Suite of Autonomous Tools for Unified and Rationalized Norms of Exchange)..
*
* This software and the attached documentation are protected by the included license.
* You must be in possession of a valid license conceded by the Cnav
* to install and use this software.
*
*******************************************************************************/
package fr.cnav.saturne.dsl.parser;  
import fr.cnav.saturne.dsl.formules.*;
import fr.cnav.saturne.dsl.formules.FormulesGenerator;
}

@members {
private FormulesGenerator gen = new FormulesGenerator();
}
@rulecatch {
catch (RecognitionException e) {
    reportError(e);
    throw e;
}
}

entry
: formule EOF
;

// Cette règle sert juste à identifier le point d'entrée de manière univoque.
formule
: logicalExpr
;

letExpr
: 'let' binding (','binding)* 'inexpr' formule
;

binding
: FIELD ':=' formule 
;

quantifiedExpr
: QUANTIFIER variableDecl 'satisfies' formule
;

variableDecl
: element										#VariableDeclElt1
| (FIELD ':' element) (',' FIELD ':' element)*	#VariableDeclElt1Elt2
;

//Grammaire des expressions 
// A noter que le traitement du NOT était ambigüe dans la BNF fourni:
// il pouvait être associé de différentes manière. "not A and B" pouvait être interprété "not (A and B)" 
// ou (not A) and B. On a choisi la seconde solution dans cette grammaire. A voir ce qui convient au final.

// La grammaire des expressions est dé-récursifiée par rapport à celle du CDC mais le langage reconnu est le même.
logicalExpr
: orExpr (CONNECTOR logicalExpr)?
; 

orExpr
: andExpr ('or' orExpr)?
;

andExpr
: notExpr ('and' andExpr)?
;

notExpr
: (NOT)? comparisonExpr
;

comparisonExpr
: arithmeticExpr (COMPOP arithmeticExpr)?
;

arithmeticExpr
: multExpr (ADDOP arithmeticExpr)?
;

multExpr
: atom (MULTOP multExpr)?
;

atom
: literal			#AtomLiteral
| element			#AtomElement
| functionCall		#AtomCall
| '(' formule ')'	#AtomParenthesis
| listeValeur		#AtomListVal
| varRef			#AtomVarRef
| letExpr			#AtomLetExpr
| quantifiedExpr	#AtomQuantifiedExpr
;

// appels des fonctions définies dans le fichier de properties (e.g. #cle)
functionCall
: FIELD '('(formule(','formule)* )? ')'
;

varRef
: '$'FIELD
;

contextSpec
: '$'FIELD ':'
;

element
: (contextSpec)? fieldRef
;

fieldRef
: FIELD
;

listeValeur
: '{' literal (','literal)* '}'
;

// Pour le literal ALPHANUM, nous retirons les simples cotes en debut et fin de valeur
literal
: NUM		#LiteralNum
| ALPHANUM	#LiteralAlphaNum
| DATE		#LiteralDate
;

//Les structures/groupes/rubriques sont traités par des règles terminales.
//Les exemples comportaient des sous-
//rubriques et sous rubriques dont 
//les numéros étaient codés alternativement sur deux ou trois chiffre.
//On prend en compte cette possibilité.
WS  : [ \r\t\u000C\n] -> skip
;
QUANTIFIER : 'some' | 'every' | 'none_or_every' | 'none'
;

DATE:  DIGIT DIGIT DIGIT DIGIT DIGIT DIGIT DIGIT DIGIT  ('D'|'d')
;
NUM:  DIGIT+ ('.' DIGIT+)?
;

CONNECTOR: '=>' | '<=>'
;
MULTOP : '*' | '/'
;
ADDOP : '+' | '-'
;
COMPOP : '=' | '<' | '>' | '<=' | '>=' | '!=' | 'in'
;
NOT : 'not'
;
//ALPHANUM: '\'' (~('\t'|'\u000C'|'\''|'\n'|'\r'))* '\''
//;
ALPHANUM: '\'' (~[\t\u000C'\n\r])* '\''
;

//ID: IDSTART (IDPART)*
//;
  
// TODO lettres + chiffres + _ + . + -
FIELD :  (IDSTART) (FIELDPART)*
;
////Order if ID and LIT is important since ID matches a subset of LIT.
//LIT: IDPART*
//;
fragment IDSTART: 'a'..'z' |  'A'..'Z' | '_';
fragment IDPART: 'a'..'z' |  'A'..'Z' | '_' | '-'|'0'..'9';
fragment FIELDPART: 'a'..'z' |  'A'..'Z' | '_' | '-'| '.'|'0'..'9';

fragment DIGIT : '0'..'9'
; 

