/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.ogn;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.utils.StandardUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class MessageTreeEditorValidateAction
extends ValidateAction {
    private StandardUtil standardUtil = new StandardUtil();

    private void filterDescendants() {
        if (this.selectedObjects != null) {
            this.selectedObjects = EcoreUtil.filterDescendants((Collection)this.selectedObjects);
        }
    }

    protected Diagnostic validate(IProgressMonitor progressMonitor) {
        progressMonitor.beginTask("Complete model selection...", 10);
        this.filterDescendants();
        return super.validate(progressMonitor);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        this.selectedObjects = new ArrayList();
        Iterator objects = selection.iterator();
        while (objects.hasNext()) {
            Object object = AdapterFactoryEditingDomain.unwrap(objects.next());
            if (object instanceof MessageTreeObject) {
                Object element = ((MessageTreeObject)object).getElement();
                Declaration declaration = ((MessageTreeObject)object).getDeclaration();
                if (element instanceof Standard) {
                    Standard standard = (Standard)element;
                    this.selectedObjects.add(standard);
                    continue;
                }
                if (!(element instanceof EObject)) continue;
                this.selectedObjects.add((EObject)element);
                this.selectedObjects.addAll(this.getAllVisibleEltNotContained((EObject)element, declaration));
                continue;
            }
            if (object instanceof EObject) {
                this.selectedObjects.add((EObject)object);
                continue;
            }
            if (object instanceof Resource) {
                this.selectedObjects.addAll(((Resource)object).getContents());
                continue;
            }
            return false;
        }
        return !this.selectedObjects.isEmpty();
    }

    private Set<EObject> getAllVisibleEltNotContained(EObject selectedElement, Declaration declaration) {
        HashSet<EObject> result = new HashSet<EObject>();
        result.addAll(this.getVisibleEltNotContained(selectedElement, declaration));
        TreeIterator iter = selectedElement.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            result.addAll(this.getVisibleEltNotContained(eObject, declaration));
        }
        return result;
    }

    private Set<EObject> getVisibleEltNotContained(EObject eObject, Declaration declaration) {
        HashSet<EObject> result = new HashSet<EObject>();
        Standard standard = this.standardUtil.getStandard(eObject);
        if (declaration == null) {
            if (standard != null && standard.getDeclarations() != null) {
                for (Declaration decl : standard.getDeclarations()) {
                    result.addAll(this.getVisibleEltNotContainedWithDeclNotNull(eObject, decl));
                }
            }
        } else {
            result.addAll(this.getVisibleEltNotContainedWithDeclNotNull(eObject, declaration));
        }
        return result;
    }

    private Set<EObject> getVisibleEltNotContainedWithDeclNotNull(EObject eObject, Declaration declaration) {
        Standard standard = this.standardUtil.getStandard(eObject);
        HashSet<EObject> result = new HashSet<EObject>();
        if (eObject instanceof Field) {
            Field field = (Field)eObject;
            if (field.getDataType() != null) {
                result.add((EObject)field.getDataType());
            }
            if (declaration != null && declaration.getFieldRefinements().get(field) != null) {
                result.add((EObject)declaration.getFieldRefinements().get(field));
            }
            result.addAll((Collection<EObject>)standard.getRules().getRulesForField(field));
        } else if (eObject instanceof Block) {
            Block block = (Block)eObject;
            if (declaration != null && declaration.getBlockRefinements().get(block) != null) {
                result.add((EObject)declaration.getBlockRefinements().get(block));
            }
        }
        return result;
    }
}

