/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.providers.detail;

import fr.cnav.autocontrole.AutocontrolPlugin;
import fr.cnav.autocontrole.IMessageUIDescriptor;
import fr.cnav.autocontrole.Messages;
import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.exception.ExceptionKind;
import fr.cnav.autocontrole.helpers.AnomalyHelper;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.autocontrole.providers.AnomalieLabelProvider;
import fr.cnav.autocontrole.providers.detail.CommonDetailProvider;
import fr.cnav.autocontrole.providers.detail.DetailTableFormatter;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.FieldRefinementDescription;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.validator.autocontrol.registry.IIndividualFieldRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AnomalieDetailProvider
extends CommonDetailProvider {
    private DetailTableFormatter anomalieFormatter;
    private DetailTableFormatter individualFormatter;
    private DetailTableFormatter natureContentFormatter;
    private AnomalieLabelProvider anomalieLabelProvider = new AnomalieLabelProvider();

    public AnomalieDetailProvider() {
        this.initAnomalieFormatter();
        this.initIndividualFormatter();
        this.initCategoryFormatter();
    }

    private void initCategoryFormatter() {
        this.natureContentFormatter = new DetailTableFormatter();
        this.natureContentFormatter.prepareValueLineSeparator();
    }

    private void initAnomalieFormatter() {
        this.anomalieFormatter = new DetailTableFormatter();
        this.anomalieFormatter.addTitle(Messages.AnomalieDetailProvider_10).addTitle(Messages.AnomalieDetailProvider_9).addTitle(Messages.AnomalieDetailProvider_0).addTitle(Messages.AnomalieDetailProvider_1).addTitle(Messages.AnomalieDetailProvider_2).addTitle(Messages.AnomalieDetailProvider_3).addTitle(Messages.AnomalieDetailProvider_4).addTitle(Messages.AnomalieDetailProvider_13).prepareValueLineSeparator();
    }

    private void initIndividualFormatter() {
        IMessageUIDescriptor messageDescriptor;
        this.individualFormatter = new DetailTableFormatter();
        this.individualFormatter.addTitle(Messages.AnomalieDetailProvider_14);
        if (StandardHelper.getInstance() != null && (messageDescriptor = StandardHelper.getInstance().getMessageDescriptor()) != null && messageDescriptor.getIndividualFields() != null) {
            for (IIndividualFieldRegistry contextDescription : StandardHelper.getInstance().getMessageDescriptor().getIndividualFields()) {
                this.individualFormatter.addTitle(contextDescription.getLabel());
            }
        }
        this.individualFormatter.prepareValueLineSeparator();
    }

    public String getText(Object selectedObject) {
        if (selectedObject instanceof Anomaly) {
            return this.getTextContextAnomaly((Anomaly)selectedObject);
        }
        return "";
    }

    private String getTextContextAnomaly(Anomaly anomaly) {
        FieldDescription anomalyCategory = this.getAnomalyCategory(anomaly);
        String formatDetailAnomalie = this.getFormatDetailAnomalie(anomaly, anomalyCategory);
        formatDetailAnomalie = String.valueOf(formatDetailAnomalie) + "---------------------------------------------------\n";
        String individualDetail = this.getIndividualDetail(anomaly, formatDetailAnomalie);
        formatDetailAnomalie = String.valueOf(formatDetailAnomalie) + individualDetail;
        if (!"".equals(individualDetail)) {
            formatDetailAnomalie = String.valueOf(formatDetailAnomalie) + "---------------------------------------------------\n";
        }
        formatDetailAnomalie = this.getEnumOrExternalContent(anomalyCategory, formatDetailAnomalie);
        return formatDetailAnomalie;
    }

    protected FieldDescription getAnomalyCategory(Anomaly anomaly) {
        Object element = MessageFile.getInstance().getNormeElt(anomaly);
        if (element != null) {
            FieldDescription standardField = null;
            if (element instanceof FieldRefinementDescription) {
                FieldRefinementDescription selectedElement = (FieldRefinementDescription)element;
                standardField = selectedElement.getField();
            } else {
                standardField = (FieldDescription)element;
            }
            return standardField;
        }
        return null;
    }

    private String getEnumOrExternalContent(FieldDescription anomalyCategory, String formatDetailAnomalie) {
        String resultFormatDetailAnomalie = formatDetailAnomalie;
        String enumDetails = this.getEnumValues(this.natureContentFormatter, anomalyCategory);
        String externalDetails = this.getExternalDescription(this.natureContentFormatter, anomalyCategory);
        resultFormatDetailAnomalie = String.valueOf(resultFormatDetailAnomalie) + enumDetails;
        resultFormatDetailAnomalie = String.valueOf(resultFormatDetailAnomalie) + externalDetails;
        if (!"".equals(enumDetails) || !"".equals(externalDetails)) {
            resultFormatDetailAnomalie = String.valueOf(resultFormatDetailAnomalie) + "---------------------------------------------------\n";
        }
        return resultFormatDetailAnomalie;
    }

    private String getIndividualDetail(Anomaly anomaly, String formatDetailAnomalie) {
        if (AnomalyHelper.isIndividualContext(anomaly)) {
            this.individualFormatter.razValue();
            this.individualFormatter.addValue("");
            if (StandardHelper.getInstance().getMessageDescriptor().getIndividualFields() != null) {
                for (IIndividualFieldRegistry contextDescription : StandardHelper.getInstance().getMessageDescriptor().getIndividualFields()) {
                    String individualValue = "";
                    String individualValueFirstPart = AnomalyHelper.getIndividualValue(anomaly, contextDescription.getFirstRubiqueFullQualifiedId());
                    if (individualValueFirstPart == null) {
                        AutoCtrlException autoCtrlException = new AutoCtrlException(ExceptionKind.ERROR_NO_VALUE_FOR_INDIVIDUAL_FIELD, contextDescription.getFirstRubiqueFullQualifiedId(), contextDescription.getLabel());
                        autoCtrlException.printStackTrace();
                        AutocontrolPlugin.log((IStatus)new Status(4, "fr.cnav.autocontrole", autoCtrlException.getMessage(), (Throwable)autoCtrlException));
                    } else {
                        individualValue = individualValueFirstPart;
                    }
                    individualValue = this.getSecondOptionalPart(anomaly, contextDescription, individualValue);
                    this.individualFormatter.addValue(individualValue);
                }
            }
            return this.individualFormatter.printTable();
        }
        return "";
    }

    private String getSecondOptionalPart(Anomaly anomaly, IIndividualFieldRegistry contextDescription, String individualValue) {
        String individualValueResult = individualValue;
        if (contextDescription.getSecondRubiqueFullQualifiedId() != null) {
            String individualValueSecondPart = AnomalyHelper.getIndividualValue(anomaly, contextDescription.getSecondRubiqueFullQualifiedId());
            if (individualValueSecondPart == null) {
                AutoCtrlException autoCtrlException = new AutoCtrlException(ExceptionKind.ERROR_NO_VALUE_FOR_INDIVIDUAL_SECONDARY_FIELD, contextDescription.getSecondRubiqueFullQualifiedId(), contextDescription.getFirstRubiqueFullQualifiedId(), contextDescription.getLabel());
                AutocontrolPlugin.log((IStatus)new Status(4, "fr.cnav.autocontrole", autoCtrlException.getMessage(), (Throwable)autoCtrlException));
            } else {
                individualValueResult = String.valueOf(individualValueResult) + "/" + individualValueSecondPart;
            }
        }
        return individualValueResult;
    }

    private String getNatureTranslation(FieldDescription selectedObject) {
        String natureTranslation = "";
        if (selectedObject != null) {
            String oldValue = selectedObject.getDataType().getNature().getName();
            if (Messages.NormeDetailTranslateNatureKey_0.equals(oldValue)) {
                natureTranslation = Messages.NormeDetailTranslateNatureValue_0;
            } else if (Messages.NormeDetailTranslateNatureKey_1.equals(oldValue)) {
                natureTranslation = Messages.NormeDetailTranslateNatureValue_1;
            } else if (Messages.NormeDetailTranslateNatureKey_2.equals(oldValue)) {
                natureTranslation = Messages.NormeDetailTranslateNatureValue_2;
            } else if (Messages.NormeDetailTranslateNatureKey_3.equals(oldValue)) {
                natureTranslation = Messages.NormeDetailTranslateNatureValue_3;
            }
        }
        return natureTranslation;
    }

    private String getFormatDetailAnomalie(Anomaly selectedObject, FieldDescription anomalyCategory) {
        return this.anomalieFormatter.razValue().addValue(this.anomalieLabelProvider.getText(9, selectedObject)).addValue(this.anomalieLabelProvider.getText(10, selectedObject)).addValue(this.anomalieLabelProvider.getText(1, selectedObject)).addValue(this.anomalieLabelProvider.getText(2, selectedObject)).addValue(this.anomalieLabelProvider.getText(4, selectedObject)).addValue(String.valueOf(this.anomalieLabelProvider.getText(5, selectedObject)) + " " + this.anomalieLabelProvider.getText(6, selectedObject)).addValue(this.anomalieLabelProvider.getText(7, selectedObject)).addValue(this.getNatureTranslation(anomalyCategory)).printTable();
    }
}

