/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.models;

import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.exception.ExceptionKind;
import fr.cnav.autocontrole.helpers.AnomalyHelper;
import fr.cnav.autocontrole.helpers.MessageHelper;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.helpers.ZipApacheUtil;
import fr.cnav.autocontrole.helpers.ZipUtil;
import fr.cnav.autocontrole.messageparser.IndividualInformationDescriptor;
import fr.cnav.autocontrole.models.ReportProvider;
import fr.cnav.autocontrole.providers.AnomalieLabelProvider;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.report.IReportLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class MessageFile {
    private static MessageFile eINSTANCE;
    private File inputFile;
    private java.util.zip.ZipFile inputZipFile = null;
    private ZipFile inputZipFileApache;
    private int lineNbr;
    private double size;
    private IReportLogger reportResult = null;
    private ReportProvider reportProvider;
    private Map<Context, DeclarationDescription> mapContext2Declaration;
    private Map<Anomaly, Context> mapAnomalieContext;
    private List<Anomaly> anomalies;
    private File reportFile;
    private String reportTempFilePath;
    private Map<Integer, IndividualInformationDescriptor> fieldLineNumberToIndividualDescriptorMap;
    private int individualNumber;
    private boolean isMsgInXmlNativeFormat;
    private Map<Context, Integer> mapContext2DeclarationRank;

    public MessageFile(File file) throws IOException {
        if (eINSTANCE != null) {
            try {
                eINSTANCE.closeZipFile();
            }
            catch (IOException e) {
                throw new AutoCtrlException(ExceptionKind.CANNOT_CLOSE_ZIP_FILE, eINSTANCE.getInputFile().getAbsoluteFile(), e.getMessage());
            }
        }
        if (ZipUtil.isZipFile(file)) {
            this.inputZipFile = new java.util.zip.ZipFile(file);
        }
        this.inputFile = file;
        this.size = this.compteSize();
        this.lineNbr = this.compteLineNumber();
        this.mapAnomalieContext = new LinkedHashMap<Anomaly, Context>();
        eINSTANCE = this;
        this.individualNumber = 0;
        this.fieldLineNumberToIndividualDescriptorMap = new HashMap<Integer, IndividualInformationDescriptor>();
    }

    public String getReportTempFilePath() {
        return this.reportTempFilePath;
    }

    public void setReportTempFilePath(String reportTempFilePath) {
        this.reportTempFilePath = reportTempFilePath;
    }

    public boolean isMsgInXmlNativeFormat() {
        return this.isMsgInXmlNativeFormat;
    }

    public void setMsgInXmlFormat(boolean msgInXmlFormat) {
        this.isMsgInXmlNativeFormat = msgInXmlFormat;
    }

    public File getReportFile() {
        return this.reportFile;
    }

    public void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    public static void razInstance() {
        eINSTANCE = null;
    }

    public void closeZipFile() throws IOException {
        if (this.inputZipFile != null) {
            this.inputZipFile.close();
        }
        if (this.inputZipFileApache != null) {
            this.inputZipFileApache.close();
        }
    }

    private int compteLineNumber() throws IOException {
        InputStream is = this.getInputFileInputStream();
        Charset charset = null;
        if (StandardHelper.getInstance() != null && StandardHelper.getInstance().getStandard() != null) {
            charset = Charset.forName(StandardHelper.getInstance().getStandard().getMessagesEncoding());
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        int cnt = 0;
        try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(is, charset));){
            while (reader.readLine() != null) {
            }
            cnt = reader.getLineNumber();
        }
        return cnt;
    }

    private double compteSize() {
        return this.inputFile.length();
    }

    public String printSize() {
        String printSize = "";
        printSize = String.valueOf(this.size) + " o";
        if (this.size > 1000000.0) {
            printSize = String.valueOf(String.format("%.2f", this.size / 1000.0 / 1000.0)) + " Mo";
        } else if (this.size > 1000.0) {
            printSize = String.valueOf(String.format("%.2f", this.size / 1000.0)) + " Ko";
        }
        return printSize;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setFieldLineNumberToIndividualDescriptorMap(Map<Integer, IndividualInformationDescriptor> fieldLineNumberToIndividualDescriptorMap) {
        this.fieldLineNumberToIndividualDescriptorMap = fieldLineNumberToIndividualDescriptorMap;
    }

    public long getLineNbr() {
        return this.lineNbr;
    }

    public String getLineNbrAsString() {
        return Long.toString(this.lineNbr);
    }

    public double getSizeMb() {
        return this.size;
    }

    public IReportLogger getReportResult() {
        return this.reportResult;
    }

    public void setReportResult(IReportLogger reportResult) {
        this.reportResult = reportResult;
    }

    public void initializeReportProvider() {
        this.reportProvider = new ReportProvider(this.reportResult);
    }

    public ReportProvider getReportProvider() {
        return this.reportProvider;
    }

    public Map<Integer, IndividualInformationDescriptor> getFieldLineNumberToIndividualDescriptorMap() {
        return this.fieldLineNumberToIndividualDescriptorMap;
    }

    public List<Anomaly> getAnomalies() {
        if (this.anomalies == null) {
            this.anomalies = new ArrayList<Anomaly>();
            if (this.reportResult.getReport().getRootContext() != null) {
                this.computeAnomaliesToContextMap(this.reportResult.getReport().getRootContext());
            }
        }
        return this.anomalies;
    }

    private void computeAnomaliesToContextMap(Context currentContext) {
        this.anomalies.addAll(currentContext.getAnomalies());
        for (Anomaly anomaly : currentContext.getAnomalies()) {
            this.mapAnomalieContext.put(anomaly, currentContext);
        }
        List subContextChildren = currentContext.getContextChildren();
        for (Context subContext : subContextChildren) {
            this.computeAnomaliesToContextMap(subContext);
        }
    }

    public int getIndividualNumber() {
        return this.individualNumber;
    }

    public void setIndividualNumber(int nbIndividualSubGroup) {
        this.individualNumber = nbIndividualSubGroup;
    }

    public InputStream getInputFileInputStream() throws ZipException, IOException {
        if (this.inputZipFile != null) {
            InputStream result = null;
            try {
                result = ZipUtil.getInputStream(this.inputZipFile);
            }
            catch (Exception exception) {}
            if (result == null) {
                this.inputZipFileApache = new ZipFile(this.inputFile, "ISO-8859-1");
                try {
                    result = ZipApacheUtil.getInputStream(this.inputZipFileApache);
                }
                catch (Exception exception) {
                    throw new AutoCtrlException(ExceptionKind.ERROR_ZIP_FILE_ACCESS);
                }
                if (result == null) {
                    throw new AutoCtrlException(ExceptionKind.ERROR_ZIP_FILE_ACCESS);
                }
            }
            return result;
        }
        return new FileInputStream(this.inputFile);
    }

    public Object getNormeElt(Object element) {
        String fullQualifedId = AnomalyHelper.getFullQualifedId(element);
        String nature = AnomalyHelper.getNature(element, this.getMapAnomalieContext(), this.getMapContext2Declaration());
        return StandardHelper.getInstance().getNormeElt(fullQualifedId, nature);
    }

    public Object getAnomalyContextFromIndividualElt(Object element, IMessageBlock individualSubGroup) {
        if (element instanceof Anomaly) {
            AnomalieLabelProvider anomalieLabelProvider = new AnomalieLabelProvider();
            int lineNumber = Integer.parseInt(anomalieLabelProvider.getText(4, element));
            return MessageHelper.getEltFromMessage(individualSubGroup, lineNumber);
        }
        return null;
    }

    public Context getContext(Anomaly anomaly) {
        return this.getMapAnomalieContext().get(anomaly);
    }

    public static MessageFile getInstance() {
        return eINSTANCE;
    }

    public Map<Anomaly, Context> getMapAnomalieContext() {
        return this.mapAnomalieContext;
    }

    public Map<Context, DeclarationDescription> getMapContext2Declaration() {
        return this.mapContext2Declaration;
    }

    public void setMapContext2Declaration(Map<Context, DeclarationDescription> mapContext2Declaration) {
        this.mapContext2Declaration = mapContext2Declaration;
    }

    public void setMapContext2DeclarationRank(Map<Context, Integer> mapContext2DeclarationRank) {
        this.mapContext2DeclarationRank = mapContext2DeclarationRank;
    }

    public Map<Context, Integer> getMapContext2DeclarationRank() {
        return this.mapContext2DeclarationRank;
    }
}

