/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.ExternalFunctionDefinition;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.CallTypeAdapter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.collections4.map.HashedMap;

public final class ExternalFunctionUtil {
    static final List<String> VALID_TYPES = Arrays.asList("bool", "alphanum", "alphanum_list", "num", "num_list", "date", "date_list", "node", "node_list", "token", "token_list");
    private static final String PARAM_DECL = " * @param ";
    private static final String BOOLEAN_TYPE = "boolean";
    private static final String BIG_DECIMAL_TYPE = "BigDecimal";
    private static final String BIG_DECIMAL_LIST_TYPE = "Iterable<IMessageFieldNum>";
    private static final String DATE_TYPE = "Date";
    private static final String DATE_LIST_TYPE = "Iterable<IMessageFieldDate>";
    private static final String OBJECT_TYPE = "Object";
    private static final String OBJECT_LIST_TYPE = "Iterable<Object>";
    private static final String STRING_TYPE = "String";
    private static final String STRING_LIST_TYPE = "Iterable<IMessageFieldAlphanum>";
    private static final String LINE_COMMENT = " * ";
    private static final String LINE_RETURN = "\n";

    private ExternalFunctionUtil() {
    }

    public static boolean isValidSignatureFormat(String externalFunctionSignature) {
        boolean isValid = true;
        if (externalFunctionSignature == null) {
            return true;
        }
        String[] colonSplit = externalFunctionSignature.split(":");
        if (colonSplit.length != 2) {
            isValid = false;
        } else {
            String returnType = colonSplit[1];
            String[] parameterTypes = colonSplit[0].split(",", -1);
            if (parameterTypes.length == 1 && "".equals(parameterTypes[0])) {
                isValid = true;
            } else {
                String[] stringArray = parameterTypes;
                int n = parameterTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String paramterType = stringArray[n2];
                    if (!VALID_TYPES.contains(paramterType)) {
                        isValid = false;
                    }
                    ++n2;
                }
            }
            if (!VALID_TYPES.contains(returnType)) {
                isValid = false;
            }
        }
        return isValid;
    }

    public static String computeSnippet(ExternalFunctionDefinition extFunction) {
        if (extFunction == null) {
            return "";
        }
        String name = extFunction.getName();
        String description = extFunction.getDescription();
        description = description != null ? description.replaceAll(LINE_RETURN, "\n * ") : "ExternalFunction " + name + ".";
        String signature = extFunction.getSignature();
        StringBuilder sb = new StringBuilder();
        if (name != null && signature != null) {
            Type returnType = CallTypeAdapter.resultTypes(signature);
            Type[] args = CallTypeAdapter.arguments(signature);
            boolean hasInjectedData = extFunction.isHasInjectedData();
            sb.append("/**\n");
            sb.append(LINE_COMMENT + description);
            sb.append("\n * \n");
            sb.append(ExternalFunctionUtil.computeJavadoc(args, hasInjectedData, returnType));
            sb.append(" */\n");
            sb.append("public static ");
            sb.append(ExternalFunctionUtil.getJavaType(returnType));
            sb.append(" ");
            sb.append(name);
            sb.append("(");
            sb.append(ExternalFunctionUtil.computeParameterSignature(args, hasInjectedData));
            sb.append(") {\n");
            sb.append("\t// TODO: Fill me\n\t");
            sb.append(ExternalFunctionUtil.computeReturnStatement(returnType));
            sb.append("}\n");
        }
        return sb.toString();
    }

    private static String computeParameterSignature(Type[] args, boolean hasInjectedData) {
        String[] parameterNames = ExternalFunctionUtil.computeParameterNames(args);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            String javaType = ExternalFunctionUtil.getJavaType(args[i]);
            sb.append(String.valueOf(javaType) + " " + parameterNames[i]);
            if (i < args.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        if (hasInjectedData) {
            sb.append(", OptionMap injectedDataMap");
        }
        return sb.toString();
    }

    private static String[] computeParameterNames(Type[] args) {
        String[] parameterNames = new String[args.length];
        HashedMap counters = new HashedMap();
        counters.put(Type.ALPHANUM, 1);
        counters.put(Type.ALPHANUM_LIST, 1);
        counters.put(Type.BOOLEAN, 1);
        counters.put(Type.DATE, 1);
        counters.put(Type.DATE_LIST, 1);
        counters.put(Type.NODE, 1);
        counters.put(Type.NODE_LIST, 1);
        counters.put(Type.NUM, 1);
        counters.put(Type.NUM_LIST, 1);
        counters.put(Type.TOKEN, 1);
        counters.put(Type.TOKEN_LIST, 1);
        counters.put(Type.UNDEFINED, 1);
        int i = 0;
        while (i < args.length) {
            Integer counter = (Integer)counters.get((Object)args[i]);
            if (counter != null) {
                counters.put(args[i], counter + 1);
            } else {
                counter = (Integer)counters.get((Object)Type.UNDEFINED);
                counters.put(Type.UNDEFINED, counter + 1);
            }
            parameterNames[i] = String.valueOf(args[i].name().toLowerCase()) + counter;
            if (args[i] == Type.BOOLEAN) {
                parameterNames[i] = "bool" + counter;
            }
            ++i;
        }
        return parameterNames;
    }

    private static String computeJavadoc(Type[] args, boolean hasInjectedData, Type returnType) {
        String[] parameterNames = ExternalFunctionUtil.computeParameterNames(args);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < args.length) {
            if (OBJECT_TYPE.equals(ExternalFunctionUtil.getJavaType(args[i]))) {
                sb.append(PARAM_DECL + parameterNames[i] + " Typed as Object by the generator but may require manual editing if the actual type is IMessageBlock or Iterable<IMessageBlock>\n");
            } else if (STRING_TYPE.equals(ExternalFunctionUtil.getJavaType(args[i]))) {
                sb.append(PARAM_DECL + parameterNames[i] + " Typed as String by the generator but may require manual editing if the actual type is IMessageFieldAlphanum or List<IMessageFieldAlphanum>\n");
            } else if (DATE_TYPE.equals(ExternalFunctionUtil.getJavaType(args[i]))) {
                sb.append(PARAM_DECL + parameterNames[i] + " Typed as Date by the generator but may require manual editing if the actual type is IMessageFieldDate or List<IMessageFieldDate>\n");
            } else if (BIG_DECIMAL_TYPE.equals(ExternalFunctionUtil.getJavaType(args[i]))) {
                sb.append(PARAM_DECL + parameterNames[i] + " Typed as BigDecimal by the generator but may require manual editing if the actual type is IMessageFieldNum or List<IMessageFieldNum>\n");
            } else {
                sb.append(PARAM_DECL + parameterNames[i] + LINE_RETURN);
            }
            ++i;
        }
        if (hasInjectedData) {
            sb.append(" * @param injectedDataMap Additional input data\n");
        }
        sb.append(" * @return an element of type " + ExternalFunctionUtil.getJavaType(returnType) + LINE_RETURN);
        return sb.toString();
    }

    private static String getJavaType(Type type) {
        String javaType = OBJECT_TYPE;
        switch (type) {
            case TOKEN: 
            case ALPHANUM: {
                javaType = STRING_TYPE;
                break;
            }
            case TOKEN_LIST: 
            case ALPHANUM_LIST: {
                javaType = STRING_LIST_TYPE;
                break;
            }
            case NUM: {
                javaType = BIG_DECIMAL_TYPE;
                break;
            }
            case NUM_LIST: {
                javaType = BIG_DECIMAL_LIST_TYPE;
                break;
            }
            case DATE: {
                javaType = DATE_TYPE;
                break;
            }
            case DATE_LIST: {
                javaType = DATE_LIST_TYPE;
                break;
            }
            case BOOLEAN: {
                javaType = BOOLEAN_TYPE;
                break;
            }
            case NODE_LIST: {
                javaType = OBJECT_LIST_TYPE;
                break;
            }
            default: {
                javaType = OBJECT_TYPE;
            }
        }
        return javaType;
    }

    private static String computeReturnStatement(Type returnType) {
        String returnStatement = "return null;\n";
        switch (returnType) {
            case TOKEN: 
            case ALPHANUM: {
                returnStatement = "return \"value\";\n";
                break;
            }
            case NUM: {
                returnStatement = "return new BigDecimal(0);\n";
                break;
            }
            case DATE: {
                returnStatement = "return new Date();\n";
                break;
            }
            case TOKEN_LIST: 
            case ALPHANUM_LIST: {
                returnStatement = "return new ArrayList<IMessageFieldAlphanum>();\n";
                break;
            }
            case NUM_LIST: {
                returnStatement = "return new ArrayList<IMessageFieldNum>();\n";
                break;
            }
            case DATE_LIST: {
                returnStatement = "return new ArrayList<IMessageFieldDate>();\n";
                break;
            }
            case NODE_LIST: {
                returnStatement = "return new ArrayList<Object>();\n";
                break;
            }
            case BOOLEAN: {
                returnStatement = "return false;\n";
                break;
            }
            default: {
                returnStatement = "return null;\n";
            }
        }
        return returnStatement;
    }
}

