/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.EnumDataTypeDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.ValueDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.syntax.AbstractFieldSyntaxControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Csl11SyntaxControl
extends AbstractFieldSyntaxControl {
    private final List<ValueDescription> activeValues;
    private final String fullQualifiedId;

    public Csl11SyntaxControl(int id, String code, FieldDescription target, ControlMessages controlMessage, DeclarationDescription declaration) {
        super(id, code, target, controlMessage, declaration);
        DataTypeDescription dataType = target.getDataType();
        List valuesList = null;
        if (dataType instanceof EnumDataTypeDescription) {
            valuesList = ((EnumDataTypeDescription)dataType).getValues();
        }
        if (!dataType.getNature().equals((Object)NatureType.ENUMERATION)) {
            throw new IllegalArgumentException("Une r\u00e8gle CSL11 ne peut \u00eatre d\u00e9clench\u00e9e sur une rubrique dont la nature n'est pas \u00e9num\u00e9r\u00e9e.");
        }
        this.fullQualifiedId = target.getFullQualifiedId();
        this.activeValues = valuesList;
    }

    @Override
    public List<FieldDescription> getUsedData() {
        if (this.getTarget() instanceof FieldDescription) {
            return Stream.of((FieldDescription)this.getTarget()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new ArrayList<FieldDescription>();
    }

    private boolean valueInEnumeration(String value) {
        int size = this.activeValues.size();
        int i = 0;
        while (i < size) {
            ValueDescription dataTypeValue = this.activeValues.get(i);
            if (dataTypeValue.getId().equals(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public IRuleResult run(IMessageField<?> subject) {
        IRuleResult result;
        if (subject.getValueAsString() == null || "".equals(subject.getValueAsString())) {
            return IRule.SUCCESS;
        }
        String value = subject.getValueAsString();
        if (value != null) {
            boolean isOneOfEnumerateValues = this.valueInEnumeration(value);
            if (!isOneOfEnumerateValues) {
                String message = this.controlMessage.getMessage("syntactic.messages.CSL11", new Object[]{this.fullQualifiedId});
                result = new RuleFailure(this, subject, subject.getParent(), message);
            } else {
                result = IRule.SUCCESS;
            }
        } else {
            result = IRule.SUCCESS;
        }
        return result;
    }
}

