/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.declaration;

import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationBlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.validator.ITreeConsumer;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.declaration.DeclarationIdentifier;
import fr.cnav.saturne.validator.declaration.IDeclarationIdentificationListener;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class DeclarationListener
implements ITreeConsumer {
    private DeclarationIdentifier identifier;
    private IMessageBlock declarationBlock;
    private DeclarationDescription declaration;
    private boolean declarationValid;
    private boolean inDeclaration;
    private HashMap<FieldDescription, Integer> field2RankMap;
    private Set<FieldDescription> keySet;
    private final HashMap<String, String> values;
    private int maxKeyRank;
    private final StandardDescription standard;
    private List<IDeclarationIdentificationListener> listeners;

    public DeclarationListener(StandardAccessor modelAccessor) {
        this.identifier = new DeclarationIdentifier(modelAccessor);
        this.keySet = this.identifier.getDeclarationPrimaryKeys();
        this.values = new HashMap();
        this.declarationValid = true;
        this.standard = modelAccessor.getStandardDescription();
        this.initFieldRankTable();
        this.listeners = new ArrayList<IDeclarationIdentificationListener>();
    }

    public void addListener(IDeclarationIdentificationListener listener) {
        this.listeners.add(listener);
    }

    private void initFieldRankTable() {
        this.field2RankMap = new HashMap();
        int rank = 0;
        rank = this.processBloc((BlockDescription)this.standard.getMessage().getHeaderBlock(), rank);
        rank = this.processBloc((BlockDescription)this.standard.getMessage().getHeaderBlock().getDeclarationBlock(), rank);
        this.processBloc(this.standard.getMessage().getFooterBlock(), rank);
        this.maxKeyRank = 0;
        for (FieldDescription key : this.keySet) {
            int keyRank = this.field2RankMap.get(key);
            if (keyRank <= this.maxKeyRank) continue;
            this.maxKeyRank = keyRank;
        }
    }

    private int processBloc(BlockDescription block, int rank) {
        int currentRank = rank;
        for (FieldDescription field : block.getFields()) {
            this.field2RankMap.put(field, currentRank++);
        }
        for (BlockDescription child : block.getChildren()) {
            currentRank = this.processBloc(child, currentRank);
        }
        return currentRank;
    }

    public DeclarationDescription getDeclaration() {
        return this.declaration;
    }

    public boolean isInDeclaration() {
        return this.inDeclaration;
    }

    public boolean isDeclarationValid() {
        return this.declarationValid;
    }

    @Override
    public void enterBlock(IMessageBlock block) {
        if (block.getStandardBlockDescription() instanceof DeclarationBlockDescription) {
            this.inDeclaration = true;
            this.declarationValid = false;
            this.declarationBlock = block;
        } else if (block.getStandardBlockDescription().equals(this.standard.getMessage().getFooterBlock())) {
            this.declarationValid = true;
        }
    }

    @Override
    public void exitBlock(IMessageBlock block) {
        if (block.getStandardBlockDescription() instanceof DeclarationBlockDescription) {
            this.inDeclaration = false;
            this.declaration = null;
            this.declarationValid = false;
            this.declarationBlock = null;
            this.values.clear();
        }
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
        this.processField(field);
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
        this.processField(field);
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
        this.processField(field);
    }

    private void processField(IMessageField<?> field) throws TreeProcessingException {
        int rank;
        if (this.keySet.contains(field.getStandardFieldDescription())) {
            this.values.put(field.getStandardFieldDescription().getFullQualifiedId(), field.getValueAsString());
        }
        if (this.keySet.size() > 0 && !this.declarationValid && (rank = this.field2RankMap.get(field.getStandardFieldDescription()).intValue()) >= this.maxKeyRank) {
            this.declaration = this.identifier.getDeclaration(this.values);
            this.declarationValid = true;
            for (IDeclarationIdentificationListener listener : this.listeners) {
                listener.signalDeclaration(this.declarationBlock, this.declaration);
            }
        }
    }

    @Override
    public void startTree() throws TreeProcessingException {
    }

    @Override
    public void endTree() throws TreeProcessingException {
    }
}

