/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class Utf8ControlSaturne
extends ResourceBundle.Control {
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        String bundleName = this.toBundleName(baseName, locale);
        ResourceBundle bundle = null;
        if ("java.class".equals(format)) {
            try {
                Class<?> bundleClass = loader.loadClass(bundleName);
                if (!ResourceBundle.class.isAssignableFrom(bundleClass)) {
                    throw new ClassCastException(String.valueOf(bundleClass.getName()) + " cannot be cast to ResourceBundle");
                }
                bundle = (ResourceBundle)bundleClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw (IOException)e.getException();
            }
        } else if ("java.properties".equals(format)) {
            bundle = this.createBundleForProperties(loader, reload, bundleName);
        } else {
            throw new IllegalArgumentException("unknown format: " + format);
        }
        return bundle;
    }

    private ResourceBundle createBundleForProperties(ClassLoader loader, boolean reload, String bundleName) throws IOException, UnsupportedEncodingException {
        PropertyResourceBundle bundle = null;
        final String resourceName = this.toResourceName(bundleName, "properties");
        final ClassLoader classLoader = loader;
        final boolean reloadFlag = reload;
        InputStream stream = null;
        try {
            stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    InputStream is = null;
                    if (reloadFlag) {
                        URLConnection connection;
                        URL url = classLoader.getResource(resourceName);
                        if (url != null && (connection = url.openConnection()) != null) {
                            connection.setUseCaches(false);
                            is = connection.getInputStream();
                        }
                    } else {
                        is = classLoader.getResourceAsStream(resourceName);
                    }
                    return is;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        if (stream != null) {
            try {
                bundle = new PropertyResourceBundle(new InputStreamReader(stream, "UTF-8"));
            }
            finally {
                stream.close();
            }
        }
        return bundle;
    }
}

