/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator;

import fr.cnav.saturne.validator.Utf8ControlSaturne;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ControlMessages {
    private static final String CONTROL_MESSAGES_DEFAULT = "controlMessages";
    private static final Object ERROR_MESSAGE_CODE_NOT_FOUND = "The properties file of the norm does not contains the message id";
    private final ResourceBundle resourceBundleNorm;
    private final ResourceBundle resourceBundleDefault;
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public ControlMessages(ResourceBundle resourceBundleNorm) {
        this(resourceBundleNorm, false);
    }

    public ControlMessages(ResourceBundle resourceBundleNorm, boolean isInWorkspace) {
        this.resourceBundleNorm = resourceBundleNorm;
        this.resourceBundleDefault = ResourceBundle.getBundle(CONTROL_MESSAGES_DEFAULT, new Utf8ControlSaturne());
        if (this.resourceBundleDefault == null && !isInWorkspace) {
            throw new IllegalStateException("The default resource bundle cannot be null");
        }
    }

    private boolean isCodeDefinedInNorm(String code) {
        if (this.resourceBundleNorm == null) {
            return false;
        }
        return this.resourceBundleNorm.containsKey(code);
    }

    public String getMessage(String code) {
        return this.getMessage(code, null);
    }

    public String getMessage(String code, Object[] arguments) {
        if (code == null) {
            throw new IllegalArgumentException("Incorrect (null) code");
        }
        String message = null;
        if (this.resourceBundleNorm == null) {
            message = this.resourceBundleDefault.getString(code);
        } else if (!this.isCodeDefinedInNorm(code)) {
            this.logger.log(Level.SEVERE, ERROR_MESSAGE_CODE_NOT_FOUND + " " + code);
            message = this.resourceBundleDefault.getString(code);
        } else {
            message = this.resourceBundleNorm.getString(code);
        }
        Object[] args = arguments == null ? new Object[]{} : arguments;
        MessageFormat messageFormat = new MessageFormat(message.replace("'", "''"));
        return messageFormat.format(args);
    }
}

