/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.runtime;

import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.runtime.BuiltinFunctions;
import java.lang.reflect.Method;
import org.eclipse.emf.common.util.EList;

public final class RulesExecUtils {
    private RulesExecUtils() {
    }

    public static boolean isInBuiltinFunctions(Expression expression) {
        if (expression instanceof FunctionCall) {
            Method[] builtinFunctions;
            FunctionCall function = (FunctionCall)expression;
            String exprName = function.getName();
            EList args = function.getArguments();
            Method[] methodArray = builtinFunctions = BuiltinFunctions.class.getMethods();
            int n = builtinFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                Method builtinFunction = methodArray[n2];
                if (builtinFunction.getName().equals(exprName) && !RulesExecUtils.isABultinFunctionWithModelAccessor(builtinFunction) && builtinFunction.getParameterTypes().length == args.size()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean isInBuiltinFunctionsWithModelAccessor(Expression expression) {
        if (expression instanceof FunctionCall) {
            Method[] builtinFunctions;
            FunctionCall function = (FunctionCall)expression;
            String exprName = function.getName();
            EList args = function.getArguments();
            Method[] methodArray = builtinFunctions = BuiltinFunctions.class.getMethods();
            int n = builtinFunctions.length;
            int n2 = 0;
            while (n2 < n) {
                Method builtinFunction = methodArray[n2];
                if (builtinFunction.getName().equals(exprName) && builtinFunction.getParameterTypes().length == args.size() + 1 && RulesExecUtils.isABultinFunctionWithModelAccessor(builtinFunction)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean isABultinFunctionWithModelAccessor(Method builtinFunction) {
        int parameterSize = builtinFunction.getParameterTypes().length;
        if (parameterSize > 0) {
            Class<?> firstParameterType = builtinFunction.getParameterTypes()[0];
            return RulesExecUtils.isModelAccessorType(firstParameterType);
        }
        return false;
    }

    private static boolean isModelAccessorType(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (type.getName().equals(ModelAccessor.class.getName())) {
            return true;
        }
        if (type.getName().equals(Object.class.getName())) {
            return false;
        }
        return RulesExecUtils.isModelAccessorType(type.getSuperclass());
    }
}

