/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.views;

import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.ui.AutocontrolUiPlugin;
import fr.cnav.autocontrole.ui.Messages;
import fr.cnav.autocontrole.ui.views.ParameterWizardPage;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ParameterWizard
extends Wizard {
    private ParameterWizardPage page;

    public ParameterWizard() {
        URL imageURL;
        this.setWindowTitle(Messages.ParametreWizard_0);
        if (StandardHelper.getInstance() != null && (imageURL = StandardHelper.getInstance().getApplicationIcon64URL()) != null) {
            ImageDescriptor imageDcr = ImageDescriptor.createFromURL((URL)imageURL);
            this.setDefaultPageImageDescriptor(imageDcr);
        }
    }

    public void addPages() {
        this.page = new ParameterWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        try {
            if (this.page != null) {
                AutocontrolUiPlugin.getDefault().getPreferenceStore().putValue("PREF_MAX_ANOMALIE", Integer.toString(this.page.getMaxAnomalies()));
                AutocontrolUiPlugin.getDefault().getPreferenceStore().putValue("ANOMALIE_GROUPING_IS_ACTIVATED", Integer.toString(this.page.getAnomalyFactorizationThreshold()));
                AutocontrolUiPlugin.getDefault().getPreferenceStore().putValue("ACTIVE_UPDATE_ON_STARTUP", Boolean.toString(this.page.getActivatorUpdateOnStartupStatus()));
            }
        }
        catch (Throwable t) {
            AutocontrolUiPlugin.log((IStatus)new Status(4, "fr.cnav.autocontrole.ui", Messages.ParametersCannotBeApplied, t));
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.ParametersCannotBeAppliedHeader, (String)Messages.ParametersCannotBeApplied);
                }
            });
        }
        return true;
    }
}

