/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.provider;

import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.BoundRefinement;
import fr.cnav.saturne.SaturneFactory;
import fr.cnav.saturne.SaturnePackage;
import fr.cnav.saturne.provider.RefinementItemProvider;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class BlockRefinementItemProvider
extends RefinementItemProvider {
    private static final String UPPER_BOUND_REFINEMENT_LABEL = "Upper bound refinement";
    private static final String LOWER_BOUND_REFINEMENT_LABEL = "Lower bound refinement";

    public BlockRefinementItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addBlockPropertyDescriptor(object);
            this.addLowerBoundPropertyDescriptor(object);
            this.addUpperBoundPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addBlockPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_BlockRefinement_block_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_BlockRefinement_block_feature", "_UI_BlockRefinement_type"), (EStructuralFeature)SaturnePackage.Literals.BLOCK_REFINEMENT__BLOCK, true, false, true, null, null, null));
    }

    protected void addLowerBoundPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_BlockRefinement_lowerBound_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_BlockRefinement_lowerBound_feature", "_UI_BlockRefinement_type"), (EStructuralFeature)SaturnePackage.Literals.BLOCK_REFINEMENT__LOWER_BOUND, true, false, false, null, null, null){

            public IItemLabelProvider getLabelProvider(Object object) {
                return new ItemPropertyDescriptor.ItemDelegator(this, BlockRefinementItemProvider.this.getRootAdapterFactory(), BlockRefinementItemProvider.this.getResourceLocator()){

                    public String getText(Object object) {
                        if (object instanceof BoundRefinement) {
                            return String.valueOf(((BoundRefinement)object).getNewBound());
                        }
                        return super.getText(object);
                    }
                };
            }
        });
    }

    protected void addUpperBoundPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_BlockRefinement_upperBound_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_BlockRefinement_upperBound_feature", "_UI_BlockRefinement_type"), (EStructuralFeature)SaturnePackage.Literals.BLOCK_REFINEMENT__UPPER_BOUND, true, false, false, null, null, null){

            public IItemLabelProvider getLabelProvider(Object object) {
                return new ItemPropertyDescriptor.ItemDelegator(this, BlockRefinementItemProvider.this.getRootAdapterFactory(), BlockRefinementItemProvider.this.getResourceLocator()){

                    public String getText(Object object) {
                        if (object instanceof BoundRefinement) {
                            return String.valueOf(((BoundRefinement)object).getNewBound());
                        }
                        return super.getText(object);
                    }
                };
            }
        });
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(SaturnePackage.Literals.BLOCK_REFINEMENT__LOWER_BOUND);
            this.childrenFeatures.add(SaturnePackage.Literals.BLOCK_REFINEMENT__UPPER_BOUND);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/BlockRefinement"));
    }

    @Override
    public String getText(Object object) {
        String result = null;
        BlockRefinement blockRefinement = (BlockRefinement)object;
        String id = null;
        String name = null;
        if (blockRefinement.getBlock() == null || blockRefinement.getBlock().getId() == null || blockRefinement.getBlock().getName() == null) {
            return "*undefined*";
        }
        id = blockRefinement.getBlock().getId();
        name = blockRefinement.getBlock().getName();
        int upperBound = blockRefinement.getUpperBound() == null ? blockRefinement.getBlock().getUpperBound() : blockRefinement.getUpperBound().getNewBound();
        int lowerBound = blockRefinement.getLowerBound() == null ? blockRefinement.getBlock().getLowerBound() : blockRefinement.getLowerBound().getNewBound();
        String upperBoundString = String.valueOf(upperBound);
        if ("-1".equals(upperBoundString)) {
            upperBoundString = "*";
        }
        result = String.valueOf(id) + " - " + name + " (" + lowerBound + "," + upperBoundString + ")";
        return result;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(BlockRefinement.class)) {
            case 2: 
            case 3: 
            case 4: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(SaturnePackage.Literals.BLOCK_REFINEMENT__LOWER_BOUND, SaturneFactory.eINSTANCE.createBoundRefinement()));
        newChildDescriptors.add(this.createChildParameter(SaturnePackage.Literals.BLOCK_REFINEMENT__UPPER_BOUND, SaturneFactory.eINSTANCE.createBoundRefinement()));
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        if (SaturnePackage.eINSTANCE.getBlockRefinement_UpperBound().equals(feature)) {
            return UPPER_BOUND_REFINEMENT_LABEL;
        }
        return LOWER_BOUND_REFINEMENT_LABEL;
    }
}

