/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.provider;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.SaturneFactory;
import fr.cnav.saturne.SaturnePackage;
import fr.cnav.saturne.provider.MessageElementItemProvider;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class BlockItemProvider
extends MessageElementItemProvider {
    public BlockItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addLowerBoundPropertyDescriptor(object);
            this.addUpperBoundPropertyDescriptor(object);
            this.addReusedBlocksPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addLowerBoundPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Block_lowerBound_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Block_lowerBound_feature", "_UI_Block_type"), (EStructuralFeature)SaturnePackage.Literals.BLOCK__LOWER_BOUND, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addUpperBoundPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Block_upperBound_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Block_upperBound_feature", "_UI_Block_type"), (EStructuralFeature)SaturnePackage.Literals.BLOCK__UPPER_BOUND, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addReusedBlocksPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Block_reusedBlocks_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Block_reusedBlocks_feature", "_UI_Block_type"), (EStructuralFeature)SaturnePackage.Literals.BLOCK__REUSED_BLOCKS, true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(SaturnePackage.Literals.BLOCK__FIELDS);
            this.childrenFeatures.add(SaturnePackage.Literals.BLOCK__CHILDREN);
            this.childrenFeatures.add(SaturnePackage.Literals.BLOCK__REUSED_FIELDS);
            this.childrenFeatures.add(SaturnePackage.Literals.BLOCK__BINDINGS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Block"));
    }

    @Override
    public String getText(Object object) {
        if (((Block)object).getId() == null || ((Block)object).getName() == null) {
            return "*undefined*";
        }
        int lowerBound = ((Block)object).getLowerBound();
        String upperBound = String.valueOf(((Block)object).getUpperBound());
        if ("-1".equals(upperBound)) {
            upperBound = "*";
        }
        String id = ((Block)object).getId();
        String name = ((Block)object).getName();
        return String.valueOf(id) + " - " + name + " (" + lowerBound + "," + upperBound + ")";
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Block.class)) {
            case 8: 
            case 9: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        Block block = (Block)object;
        int siblingNumber = block.getChildren().size();
        Block createdBlock = SaturneFactory.eINSTANCE.createBlock();
        createdBlock.setId("ID_" + siblingNumber);
        createdBlock.setName("NAME_" + siblingNumber);
        newChildDescriptors.add(this.createChildParameter(SaturnePackage.Literals.BLOCK__CHILDREN, createdBlock));
        int fieldNumber = block.getFields().size() + 1;
        Field createdField = SaturneFactory.eINSTANCE.createField();
        createdField.setId("ID_" + fieldNumber);
        createdField.setName("NAME_" + fieldNumber);
        newChildDescriptors.add(this.createChildParameter(SaturnePackage.Literals.BLOCK__FIELDS, createdField));
    }
}

