/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.dsl.parser.configuration.StandardParserConfiguration;
import java.util.ArrayList;
import java.util.List;

public class DslConvertPos {
    private static final char COMA = ',';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char CLOSE_PARENTHESIS = ')';
    private static final char VARIABLE_CALL = '$';
    private static final char ALIAS_MACRO_CALL = '@';
    private static final String RUB = "$rub";
    private static final String ROOT = "$root";
    List<RangeParserMdlPosCouple> rangeParserMdlPosCouples = new ArrayList<RangeParserMdlPosCouple>();

    public DslConvertPos(String modelExpr, String contextFqId, String subjectFqId, List<StandardParserConfiguration.AliasForParser> aliases) {
        this.fillCouples(modelExpr, contextFqId, subjectFqId, aliases);
    }

    public int convertFromParsedPositionIntoModelPosition(int parserPos) {
        for (RangeParserMdlPosCouple rangeParserMdlPosCouple : this.rangeParserMdlPosCouples) {
            if (!rangeParserMdlPosCouple.isInParserRange(parserPos)) continue;
            return rangeParserMdlPosCouple.convert(parserPos);
        }
        return -1;
    }

    private void fillCouples(String modelExpr, String contextFqId, String subjectFqId, List<StandardParserConfiguration.AliasForParser> aliases) {
        boolean inVar = false;
        StringBuilder currentVar = null;
        StringBuilder curentDslNotInChar = null;
        int currentOffsetParserPos = 0;
        int currentOffsetMdlPos = 0;
        if (modelExpr == null) {
            return;
        }
        int i = 0;
        while (i < modelExpr.length()) {
            char c = modelExpr.charAt(i);
            if (c == '$' || c == '@') {
                if (curentDslNotInChar != null) {
                    int idxStartParser = currentOffsetParserPos + curentDslNotInChar.length() - 1;
                    int idxStartModel = currentOffsetMdlPos + curentDslNotInChar.length() - 1;
                    this.rangeParserMdlPosCouples.add(new RangeParserMdlPosCouple(currentOffsetParserPos, idxStartParser, currentOffsetMdlPos, idxStartModel));
                    currentOffsetParserPos = idxStartParser + 1;
                    currentOffsetMdlPos = idxStartParser + 1;
                    curentDslNotInChar = null;
                }
                inVar = true;
                currentVar = new StringBuilder();
                currentVar.append(c);
            } else if (inVar && c != ' ' && c != '\t' && c != ')' && c != ',') {
                currentVar.append(c);
            } else if (inVar) {
                inVar = false;
                String var = currentVar.toString();
                String varParser = this.getVarParser(contextFqId, subjectFqId, aliases, var);
                int idxStartParser = currentOffsetParserPos + varParser.length() - 1;
                int idxStartModel = currentOffsetMdlPos + var.length() - 1;
                this.rangeParserMdlPosCouples.add(new RangeParserMdlPosCouple(currentOffsetParserPos, idxStartParser, currentOffsetMdlPos, idxStartModel));
                currentOffsetParserPos = idxStartParser + 1;
                currentOffsetMdlPos = idxStartModel + 1;
                curentDslNotInChar = new StringBuilder();
                curentDslNotInChar.append(c);
            } else {
                if (curentDslNotInChar == null) {
                    curentDslNotInChar = new StringBuilder();
                }
                curentDslNotInChar.append(c);
            }
            ++i;
        }
        if (curentDslNotInChar != null) {
            this.updateLastCHarPosition(curentDslNotInChar, currentOffsetParserPos, currentOffsetMdlPos);
        }
    }

    private String getVarParser(String contextFqId, String subjectFqId, List<StandardParserConfiguration.AliasForParser> aliases, String var) {
        String varParser = var;
        if (aliases != null) {
            for (StandardParserConfiguration.AliasForParser aliasForParser : aliases) {
                if (!aliasForParser.getKey().equals(var)) continue;
                varParser = aliasForParser.getValue();
            }
        }
        if (RUB.equals(var)) {
            varParser = subjectFqId;
        } else if (ROOT.equals(var)) {
            varParser = contextFqId;
        }
        return varParser;
    }

    private void updateLastCHarPosition(StringBuilder curentDslNotInChar, int currentOffsetParserPos, int currentOffsetMdlPos) {
        int idxStartParser = currentOffsetParserPos + curentDslNotInChar.length() - 1;
        int idxStartModel = currentOffsetMdlPos + curentDslNotInChar.length() - 1;
        this.rangeParserMdlPosCouples.add(new RangeParserMdlPosCouple(currentOffsetParserPos, idxStartParser, currentOffsetMdlPos, idxStartModel));
        this.rangeParserMdlPosCouples.add(new RangeParserMdlPosCouple(currentOffsetParserPos + 1, currentOffsetParserPos + curentDslNotInChar.length(), currentOffsetMdlPos + 1, currentOffsetMdlPos + curentDslNotInChar.length()));
    }

    static final class RangeParserMdlPosCouple {
        private int startPosParser;
        private int endPosParser;
        private int startPosMdl;
        private int endPosMdl;

        RangeParserMdlPosCouple(int startPosParser, int endPosParser, int startPosMdl, int endPosMdl) {
            this.startPosParser = startPosParser;
            this.endPosParser = endPosParser;
            this.startPosMdl = startPosMdl;
            this.endPosMdl = endPosMdl;
        }

        public int convert(int parserPos) {
            if (this.endPosParser - this.startPosParser >= this.endPosMdl - this.startPosMdl) {
                if (parserPos - this.startPosParser < this.endPosMdl - this.startPosMdl) {
                    return parserPos - this.startPosParser + this.startPosMdl;
                }
                return this.endPosMdl;
            }
            return parserPos + (this.startPosParser - this.startPosMdl);
        }

        public boolean isInParserRange(int parserPos) {
            return parserPos >= this.startPosParser && parserPos <= this.endPosParser;
        }

        public boolean isInMdlRange(int mdlPos) {
            return mdlPos >= this.startPosMdl && mdlPos <= this.endPosMdl;
        }
    }
}

