/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.api.model.access;

import fr.cnav.saturne.AbstractBinding;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.ForeignKeyBinding;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.GenericRuleDescription;
import fr.cnav.saturne.api.model.access.IdQualifiedElementDescription;
import fr.cnav.saturne.api.model.access.MessageElementDescription;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.api.model.access.StandardMapUtils;
import java.util.ArrayList;
import java.util.List;

public class FieldDescription
extends MessageElementDescription {
    private Field field;
    private DataTypeDescription dataType;

    public FieldDescription(Field theField, BlockDescription theParent, StandardMapUtils standardMapUtils) {
        super(theField, theParent, standardMapUtils);
        this.field = theField;
        standardMapUtils.updateMaps(this.getFullQualifiedId(), this);
        DataType dataTypeField = this.field.getDataType();
        if (dataTypeField != null) {
            this.dataType = standardMapUtils.getDataTypeDescription(dataTypeField.getFullQualifiedId());
        }
    }

    public DataTypeDescription getDataType() {
        return this.dataType;
    }

    public boolean isDeclarationKey() {
        return this.field.isDeclarationKey();
    }

    public List<GenericRuleDescription> getRules() {
        StandardDescription standard;
        IdQualifiedElementDescription cursor = this;
        while (cursor != null && !(cursor instanceof StandardDescription)) {
            cursor = cursor instanceof MessageElementDescription ? ((MessageElementDescription)cursor).getParent() : null;
        }
        List<GenericRuleDescription> allRules = new ArrayList<GenericRuleDescription>();
        if (cursor != null && (standard = (StandardDescription)cursor).getRules() != null) {
            allRules = standard.getRules().getRulesForField(this);
        }
        return allRules;
    }

    public boolean isForeignKey() {
        Block block;
        if (this.field.eContainer() instanceof Block && (block = (Block)this.field.eContainer()).getBindings() != null) {
            return this.isForeignKey(block);
        }
        return false;
    }

    protected boolean isForeignKey(Block block) {
        for (AbstractBinding binding : block.getBindings().getBindings()) {
            if (!(binding instanceof ForeignKeyBinding)) continue;
            ForeignKeyBinding keyBinding = (ForeignKeyBinding)binding;
            Field localField = keyBinding.getLocalField();
            if (!this.field.getFullQualifiedId().equals(localField.getFullQualifiedId())) continue;
            return true;
        }
        return false;
    }
}

