/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.messageparser;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.validator.conversion.xml.BlockDeclarationAnnotation;
import fr.cnav.saturne.validator.message.DeclarationMessageBlock;
import fr.cnav.saturne.validator.message.api.IDeclarationMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Context2DeclarationCaches {
    private Map<String, DeclarationDescription> mapDeclarationName2Declaration;
    private Map<Context, DeclarationDescription> mapContext2Declaration;
    private Map<Context, Integer> mapContext2DeclarationRank;
    private Map<String, List<Context>> fullQIDToOrderedContextsMap = new HashMap<String, List<Context>>();
    private StandardAccessor standard;

    public Context2DeclarationCaches(IMessageBlock rootMessageBlock, Context rootContext, StandardAccessor standard) {
        Objects.nonNull(rootMessageBlock);
        Objects.nonNull(rootContext);
        Objects.nonNull(standard);
        this.standard = standard;
        this.mapContext2Declaration = new HashMap<Context, DeclarationDescription>();
        this.mapContext2DeclarationRank = new HashMap<Context, Integer>();
        this.fullQIDToOrderedContextsMap = new HashMap<String, List<Context>>();
        this.fillContextListInExplOrder(rootContext);
        this.mapDeclarationName2Declaration = new HashMap<String, DeclarationDescription>();
        for (DeclarationDescription declaration : standard.getStandardDescription().getDeclarations()) {
            this.mapDeclarationName2Declaration.put(declaration.getName(), declaration);
        }
        this.extractMappings(rootMessageBlock, rootContext);
    }

    private void extractMappings(IMessageBlock rootMsgBlock, Context rootCtxt) {
        for (List children : rootMsgBlock.getChildren()) {
            boolean foundDecl = false;
            int curDeclIdx = 0;
            for (IMessageBlock messageBlockChild : children) {
                if (!(messageBlockChild instanceof IDeclarationMessageBlock)) continue;
                foundDecl = true;
                IDeclarationMessageBlock declarationMessageBlock = (IDeclarationMessageBlock)messageBlockChild;
                String name = this.getDeclarationName(declarationMessageBlock);
                DeclarationDescription currentDeclaration = this.mapDeclarationName2Declaration.get(name);
                this.fillContextMaps(messageBlockChild, currentDeclaration, ++curDeclIdx);
            }
            if (!foundDecl) continue;
            return;
        }
        for (List children : rootMsgBlock.getChildren()) {
            for (IMessageBlock messageBlockChild : children) {
                this.extractMappings(messageBlockChild, rootCtxt);
            }
        }
    }

    private String getDeclarationName(IDeclarationMessageBlock declarationMessageBlock) {
        String name = "";
        for (Object annotation : ((DeclarationMessageBlock)declarationMessageBlock).getAnnotations()) {
            if (!(annotation instanceof BlockDeclarationAnnotation)) continue;
            name = ((BlockDeclarationAnnotation)annotation).getDeclaration().getName();
        }
        return name;
    }

    public Map<Context, DeclarationDescription> getMapContext2Declaration() {
        return this.mapContext2Declaration;
    }

    public Map<Context, Integer> getMapContext2DeclarationRank() {
        return this.mapContext2DeclarationRank;
    }

    private void fillContextMaps(IMessageBlock messageBlock, DeclarationDescription declaration, int declarationRank) {
        if (this.fullQIDToOrderedContextsMap.containsKey(messageBlock.getStandardBlockDescription().getFullQualifiedId())) {
            for (Context context : this.fullQIDToOrderedContextsMap.get(messageBlock.getStandardBlockDescription().getFullQualifiedId())) {
                if (this.mapContext2Declaration.containsKey(context)) continue;
                this.mapContext2Declaration.put(context, declaration);
                this.mapContext2DeclarationRank.put(context, declarationRank);
                break;
            }
        }
        for (List children : messageBlock.getChildren()) {
            for (IMessageBlock messageBlockChild : children) {
                this.fillContextMaps(messageBlockChild, declaration, declarationRank);
            }
        }
    }

    private void fillContextListInExplOrder(Context context) {
        if (this.isBlockInDeclaration(context.getblockQualifiedId())) {
            if (!this.fullQIDToOrderedContextsMap.containsKey(context.getblockQualifiedId())) {
                this.fullQIDToOrderedContextsMap.put(context.getblockQualifiedId(), new ArrayList());
            }
            this.fullQIDToOrderedContextsMap.get(context.getblockQualifiedId()).add(context);
        }
        for (Context curContext : context.getContextChildren()) {
            this.fillContextListInExplOrder(curContext);
        }
    }

    private boolean isBlockInDeclaration(String blockFullQualifiedId) {
        Block curBlock = this.standard.getBlock(blockFullQualifiedId);
        if (curBlock != null) {
            return this.isBlockInDeclaration(curBlock);
        }
        return false;
    }

    private boolean isBlockInDeclaration(Block curBlock) {
        if (curBlock instanceof DeclarationBlock) {
            return true;
        }
        if (curBlock.eContainer() instanceof Block) {
            return this.isBlockInDeclaration((Block)curBlock.eContainer());
        }
        return false;
    }
}

