/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.syntax.AbstractBlockSyntaxControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Cst05SyntaxControl
extends AbstractBlockSyntaxControl {
    public Cst05SyntaxControl(int id, String code, BlockDescription target, ControlMessages controlMessage, DeclarationDescription declaration) {
        super(id, code, target, controlMessage, declaration);
    }

    @Override
    public List<FieldDescription> getUsedData() {
        if (this.getTarget() instanceof FieldDescription) {
            return Stream.of((FieldDescription)this.getTarget()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new ArrayList<FieldDescription>();
    }

    @Override
    public IRuleResult run(IMessageBlock context) {
        IRuleResult result = IRule.SUCCESS;
        List<IMessageField<?>> fields = context.getFields();
        int size = fields.size();
        int i = 0;
        while (i < size - 1) {
            if (fields.get(i).getFieldLocalizer().getLineNumber() > fields.get(i + 1).getFieldLocalizer().getLineNumber()) {
                IMessageField<?> misplaced = fields.get(i);
                String fullQualifiedId = misplaced.getStandardFieldDescription().getFullQualifiedId();
                String message = this.controlMessage.getMessage("syntactic.messages.CST05", new Object[]{fullQualifiedId});
                result = new RuleFailure(this, misplaced, misplaced.getParent(), message);
            }
            ++i;
        }
        return result;
    }
}

