/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.initializer;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.validator.positional.FieldSpecification;
import fr.cnav.saturne.validator.positional.FooterSpecification;
import fr.cnav.saturne.validator.positional.FormatSpecification;
import fr.cnav.saturne.validator.positional.HeaderSpecification;
import fr.cnav.saturne.validator.positional.PositionalFactory;
import fr.cnav.saturne.validator.positional.PositionalPackage;
import fr.cnav.saturne.validator.positional.RecordIdSpecification;
import fr.cnav.saturne.validator.positional.RecordSpecification;

public class FormatSpecificationInitializer {
    private static PositionalFactory positionalFactory = PositionalPackage.eINSTANCE.getPositionalFactory();
    private int indexFieldPos;
    private int blockIDMaxLength;
    private Standard standard;
    private FormatSpecification formatSpecification;
    private boolean withHeaderAndFooter;

    public FormatSpecificationInitializer(Standard standard) {
        this(standard, false);
    }

    public FormatSpecificationInitializer(Standard standard, boolean withHeaderAndFooter) {
        this.withHeaderAndFooter = withHeaderAndFooter;
        this.formatSpecification = positionalFactory.createFormatSpecification();
        this.formatSpecification.setFileExtension("txt");
        this.formatSpecification.setStandard(standard);
        this.formatSpecification.setTrimmingCharacter(" ");
        this.formatSpecification.setFormatName(String.valueOf(standard.getName()) + " positional format");
        this.formatSpecification.setEndRecordDelimiter("\n");
        this.standard = standard;
        this.blockIDMaxLength = 0;
    }

    public FormatSpecification initModel() {
        this.addFormatSpec();
        return this.formatSpecification;
    }

    private void addFormatSpec() {
        this.computeIdSize((Block)this.standard.getMessage().getHeaderBlock());
        this.computeIdSize(this.standard.getMessage().getFooterBlock());
        this.addRecordIDSpec();
        if (this.withHeaderAndFooter) {
            this.addRecordHeaderSpec((Block)this.standard.getMessage().getHeaderBlock());
            this.addRecordFooterSpec(this.standard.getMessage().getFooterBlock());
            this.addRecordSpec((Block)this.standard.getMessage().getHeaderBlock().getDeclarationBlock());
        } else {
            this.addRecordSpec((Block)this.standard.getMessage().getHeaderBlock());
            this.addRecordSpec(this.standard.getMessage().getFooterBlock());
        }
    }

    private void addRecordFooterSpec(Block parentBlock) {
        for (Field footerField : parentBlock.getChildrenFields()) {
            FooterSpecification footerSpecification = positionalFactory.createFooterSpecification();
            footerSpecification.setField(footerField);
            this.formatSpecification.getFooterSpecifications().add((Object)footerSpecification);
        }
        for (Block block : parentBlock.getChildren()) {
            this.addRecordFooterSpec(block);
        }
    }

    private void addRecordHeaderSpec(Block parentBlock) {
        for (Field headerField : parentBlock.getChildrenFields()) {
            HeaderSpecification headerSpecification = positionalFactory.createHeaderSpecification();
            headerSpecification.setField(headerField);
            this.formatSpecification.getHeaderSpecifications().add((Object)headerSpecification);
        }
        for (Block block : parentBlock.getChildren()) {
            this.addRecordHeaderSpec(block);
        }
    }

    private void addRecordIDSpec() {
        if (this.blockIDMaxLength > 0) {
            RecordIdSpecification recordIdSpecification = positionalFactory.createRecordIdSpecification();
            recordIdSpecification.setRecordTypeStartPosition(1);
            recordIdSpecification.setRecordTypeEndPosition(this.blockIDMaxLength);
            this.formatSpecification.getIdSpecifications().add((Object)recordIdSpecification);
        }
    }

    private void computeIdSize(Block block) {
        if (block != null) {
            int currentFQIDLength;
            String blockId = block.getFullQualifiedId();
            if (blockId != null && (currentFQIDLength = blockId.length()) > this.blockIDMaxLength) {
                this.blockIDMaxLength = currentFQIDLength;
            }
            for (Block blockChild : block.getChildrenBlocks()) {
                this.computeIdSize(blockChild);
            }
        }
    }

    private void addRecordSpec(Block block) {
        if (block != null) {
            this.indexFieldPos = this.blockIDMaxLength;
            RecordSpecification recordSpecification = positionalFactory.createRecordSpecification();
            for (Field field : block.getChildrenFields()) {
                ++this.indexFieldPos;
                FieldSpecification fieldSpecification = positionalFactory.createFieldSpecification();
                fieldSpecification.setField(field);
                fieldSpecification.setStartPosition(this.indexFieldPos);
                this.indexFieldPos = this.indexFieldPos + field.getDataType().getMaxLength() - 1;
                fieldSpecification.setEndPosition(this.indexFieldPos);
                recordSpecification.getFields().add((Object)fieldSpecification);
            }
            recordSpecification.setBlock(block);
            recordSpecification.setRecordTypeRegex(block.getId());
            recordSpecification.setRecordLength(this.indexFieldPos);
            this.formatSpecification.getRecords().add((Object)recordSpecification);
            for (Block childBlock : block.getChildrenBlocks()) {
                this.addRecordSpec(childBlock);
            }
        }
    }

    public FormatSpecification getFormatSpecification() {
        return this.formatSpecification;
    }
}

