/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.functions;

import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.functions.ValidationFunctionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class HelperRulesProperties {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties getRulesProperties(AbstractKBDescriptor registeredKBDescriptor) throws ValidationFunctionException {
        Properties properties = null;
        String rulesUsageOverridePath = System.getProperty("fr.cnav.saturne.rules.properties");
        if (rulesUsageOverridePath != null && !rulesUsageOverridePath.isEmpty()) {
            File file = new File(rulesUsageOverridePath);
            if (!file.exists()) throw new ValidationFunctionException("The properties file used to specified the rule's usage and given by system property does not exists : " + rulesUsageOverridePath);
            Properties tempProperties = new Properties();
            FileInputStream inStream = null;
            try {
                try {
                    inStream = new FileInputStream(file);
                    tempProperties.load(inStream);
                    this.checksRuleUsagePropertiesValidity(registeredKBDescriptor, tempProperties);
                    properties = tempProperties;
                }
                catch (FileNotFoundException e) {
                    throw new ValidationFunctionException("The properties file for rules usages override could not be load correctly.", e);
                }
                catch (IOException e) {
                    throw new ValidationFunctionException("The properties file for rules usages override could not be load correctly.", e);
                }
            }
            catch (Throwable throwable) {
                if (inStream == null) throw throwable;
                try {
                    inStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new ValidationFunctionException("The opened properties file for rules usages override could not be closed.");
                }
            }
            if (inStream == null) return properties;
            try {
                inStream.close();
                return properties;
            }
            catch (IOException iOException) {
                throw new ValidationFunctionException("The opened properties file for rules usages override could not be closed.");
            }
        }
        InputStream rulesUsageOverrideResource = this.getClass().getClassLoader().getResourceAsStream("fr.cnav.saturne.rules.properties");
        if (rulesUsageOverrideResource == null) return properties;
        try {
            try {
                Properties tempProperties = new Properties();
                tempProperties.load(rulesUsageOverrideResource);
                this.checksRuleUsagePropertiesValidity(registeredKBDescriptor, tempProperties);
                properties = tempProperties;
            }
            catch (IOException e) {
                throw new ValidationFunctionException("The properties file for rules usages override could not be load correctly.", e);
            }
        }
        catch (Throwable throwable) {
            try {
                rulesUsageOverrideResource.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new ValidationFunctionException("The opened properties file for rules usages override could not be closed.");
            }
        }
        try {
            rulesUsageOverrideResource.close();
            return properties;
        }
        catch (IOException iOException) {
            throw new ValidationFunctionException("The opened properties file for rules usages override could not be closed.");
        }
    }

    private void checksRuleUsagePropertiesValidity(AbstractKBDescriptor registeredKBDescriptor, Properties properties) throws ValidationFunctionException {
        ArrayList<String> errorMessages = new ArrayList<String>();
        Standard usedStandard = registeredKBDescriptor.getModelAccessor().getStandard();
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key instanceof String && value instanceof String) {
                Iterator rulesIte = usedStandard.getRules().getRules().iterator();
                boolean ruleFound = false;
                while (rulesIte.hasNext() && !ruleFound) {
                    GenericRule rule = (GenericRule)rulesIte.next();
                    if (!key.toString().equals(rule.getFullId())) continue;
                    ruleFound = true;
                }
                if (!ruleFound) {
                    errorMessages.add("The rule \"" + key + "\" specified in the rule usage properties file does not exists in the used standard.\n");
                }
                if (RuleCriticity.BLOCKING.getLiteral().toLowerCase().equals(value.toString().toLowerCase()) || RuleCriticity.NOT_BLOCKING.getLiteral().toLowerCase().equals(value.toString().toLowerCase()) || RuleCriticity.INACTIVE.getLiteral().toLowerCase().equals(value.toString().toLowerCase())) continue;
                errorMessages.add("The rule \"" + key + "\" specified in the rule usage properties file have a value not authorized : " + value + ". Value should be \"Inactive\" or \"Blocking\" or \"NotBlocking\"\n");
                continue;
            }
            errorMessages.add("The entry \"" + key.toString() + "-" + value + "\" in the rule usage properties file has an incorrect type. All keys and values must be String\n");
        }
        if (errorMessages.size() > 0) {
            StringBuilder errorMessage = new StringBuilder("The rule usage properties file contains invalid entries : \n");
            for (String message : errorMessages) {
                errorMessage.append(message);
            }
            throw new ValidationFunctionException(errorMessage.toString());
        }
    }
}

