/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.csv;

import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.conversion.ConversionSerializationException;
import fr.cnav.saturne.validator.conversion.csv.CSVSerializer;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;

public class CSVStreamSerializer
extends CSVSerializer {
    private String[] currentBlockLine;

    public CSVStreamSerializer(Standard theStandard, OutputStream outputStream, String encoding, char theDelimiter, char theSeparator) throws ConversionSerializationException {
        super(theStandard, outputStream, encoding, theDelimiter, theSeparator);
    }

    public CSVStreamSerializer(Standard theStandard, Writer parent, String encoding) throws ConversionSerializationException {
        super(theStandard, parent, encoding);
    }

    @Override
    public void startTree() throws TreeProcessingException {
        super.startTree();
    }

    @Override
    public void endTree() throws TreeProcessingException {
        this.writeCurrentBlockLineInStream();
        super.endTree();
    }

    @Override
    public void enterBlock(IMessageBlock block) throws TreeProcessingException {
        this.writeCurrentBlockLineInStream();
        if (block.getStandardBlockDescription() instanceof BlockDescription) {
            List fields = ((BlockDescription)block.getStandardBlockDescription()).getFields();
            this.currentBlockLine = new String[fields.size() + 1];
            this.currentBlockLine[0] = block.getStandardBlockDescription().getFullQualifiedId();
        }
    }

    private void writeCurrentBlockLineInStream() {
        if (this.currentBlockLine != null) {
            this.csvWriter.writeNext(this.currentBlockLine);
            this.currentBlockLine = null;
        }
    }

    @Override
    public void exitBlock(IMessageBlock block) throws TreeProcessingException {
    }

    @Override
    public void signalAlphanumField(IMessageFieldAlphanum field) throws TreeProcessingException {
        this.writeFieldInCurrentBlockLine(field);
    }

    @Override
    public void signalNumericField(IMessageFieldNum field) throws TreeProcessingException {
        this.writeFieldInCurrentBlockLine(field);
    }

    @Override
    public void signalDateField(IMessageFieldDate field) throws TreeProcessingException {
        this.writeFieldInCurrentBlockLine(field);
    }

    private void writeFieldInCurrentBlockLine(IMessageField<?> messageField) {
        this.currentBlockLine[messageField.getIndex() + 1] = messageField.getOriginalValueAsString();
    }
}

