/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.requestor;

import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.dsl.requestor.IRequestorMessageExtractor;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.SaturneValidatorException;
import fr.cnav.saturne.validator.conversion.TreeBuilder;
import fr.cnav.saturne.validator.conversion.keyvalue.SequentialReader;
import fr.cnav.saturne.validator.functions.ValidationFunctionException;
import fr.cnav.saturne.validator.message.MessageRecuperator;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import fr.cnav.saturne.validator.report.impl.GenericReportLogger;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RequestorMessageExtractor
implements IRequestorMessageExtractor {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";
    private StandardAccessor standardAccessor;

    public RequestorMessageExtractor(StandardAccessor standardAccessor) {
        this.standardAccessor = standardAccessor;
    }

    @Override
    public List<IMessageBlock> getContextsFormKVMessageFile(InputStream messageFile) throws ValidationFunctionException {
        Objects.requireNonNull(messageFile);
        GenericReportLogger reportLogger = new GenericReportLogger(this.standardAccessor.getStandard(), false, new OptionMap());
        ControlMessages controlMessage = new ControlMessages(null);
        TreeBuilder treeBuilder = new TreeBuilder(this.standardAccessor, reportLogger, controlMessage, new SequentialReader(this.standardAccessor.getStandardDescription(), new OptionMap(), controlMessage, this.standardAccessor, messageFile, Charset.forName(this.standardAccessor.getStandardDescription().getMessagesEncoding())));
        MessageRecuperator messageRecuperator = new MessageRecuperator();
        treeBuilder.addConsumer(messageRecuperator);
        treeBuilder.addConsumer(reportLogger);
        try {
            treeBuilder.convert();
        }
        catch (SaturneValidatorException | TooManyAnomaliesException e) {
            throw new ValidationFunctionException(e);
        }
        IMessageBlock mainMessage = messageRecuperator.getRootMessageBlock();
        ArrayList<IMessageBlock> result = new ArrayList<IMessageBlock>();
        result.add(mainMessage);
        return result;
    }

    @Override
    public List<IMessageBlock> getContextsFormXMLMessageFile(InputStream messageFile) throws ValidationFunctionException {
        Objects.requireNonNull(messageFile);
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public List<IMessageBlock> getContextsFormPFXMessageFile(InputStream messageFile) throws ValidationFunctionException {
        Objects.requireNonNull(messageFile);
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public List<IMessageBlock> getContextsFormCSVMessageFile(InputStream messageFile) throws ValidationFunctionException {
        Objects.requireNonNull(messageFile);
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }
}

